/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device.common;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificateOwner;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import java.util.Objects;

public class CertificateFilterPrincipalFilter
implements IPrincipalFilter {
    private final IX509CertificateFilter certificateFilter;

    public CertificateFilterPrincipalFilter(IX509CertificateFilter certificateFilter) {
        Objects.requireNonNull(certificateFilter, "certificate filter is required");
        this.certificateFilter = certificateFilter;
    }

    @Override
    public boolean accept(IPrincipal principal) {
        if (principal instanceof IX509PublicKeyCertificateOwner) {
            IX509PublicKeyCertificateOwner co = (IX509PublicKeyCertificateOwner)principal;
            IX509PublicKeyCertificate cert = co.getX509PublicKeyCertificate();
            return this.certificateFilter.accept((IX509Certificate)cert);
        }
        return false;
    }
}

