/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.device;

import de.intarsys.security.app.ApplicationException;
import de.intarsys.security.app.IApplication;
import de.intarsys.security.device.EnumDeviceState;
import de.intarsys.security.device.ICredential;
import de.intarsys.security.device.ICredentialFilter;
import de.intarsys.security.device.IDeviceProvider;
import de.intarsys.security.device.IPrincipal;
import de.intarsys.security.device.IPrincipalFilter;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.component.IIdentifiable;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.notice.INoticesSupport;
import de.intarsys.tools.reflect.IAccessSupport;
import de.intarsys.tools.reflect.InvocableArgument;
import de.intarsys.tools.reflect.InvocableMethod;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.util.Iterator;

public interface IDevice
extends IIdentifiable,
IAttributeSupport,
IAccessSupport,
INotificationSupport,
INoticesSupport {
    public static final String APP_EID = "EID";
    public static final String APP_AUTHENTICATION = "Authentication";
    public static final String APP_ENCRYPTION = "Encryption";
    public static final String APP_SIGNATURE = "Signature";
    public static final Attribute ATTR_STATE = new Attribute("state");
    public static final String ARG_DEVICE = "device";
    public static final String ARG_ID = "id";

    public Object control(String var1, IArgs var2) throws ApplicationException;

    public IApplication createApplication(String var1, IArgs var2) throws ObjectCreationException;

    default public <A extends IApplication> A createApplication(Class<A> type, IArgs args) throws ObjectCreationException {
        return (A)((IApplication)type.cast(this.createApplication(type.getName(), args)));
    }

    public IDeviceProvider getDeviceProvider();

    @InvocableMethod
    public EnumDeviceState getState();

    @InvocableMethod
    public Iterator<ICredential> listCredentials(@InvocableArgument(name="filter", converter=CommonDevice.CredentialFilterConverter.class) ICredentialFilter var1);

    @InvocableMethod
    public Iterator<IPrincipal> listPrincipals(@InvocableArgument(name="filter", converter=CommonDevice.PrincipalFilterConverter.class) IPrincipalFilter var1);

    public void refresh();
}

