/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.signature;

import de.intarsys.aaa.authorization.api.AuthorizationStrategy;
import de.intarsys.aaa.resource.IOperation;
import de.intarsys.aaa.resource.IResource;
import de.intarsys.aaa.resource.SimpleObjectResource;
import de.intarsys.aaa.resource.SimpleOperation;
import de.intarsys.security.app.IAuthenticatedApplication;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.device.processor.ISignerPreprocessor;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.factory.InstanceSpec;
import de.intarsys.tools.factory.Outlet;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public class SignerTools {
    public static void checkAccess(IDevice device) {
        String deviceId = device.getId() + "@" + device.getDeviceProvider().getId();
        SimpleObjectResource resource = SimpleObjectResource.createFromClass(IDevice.class, (String)deviceId);
        SimpleOperation operation = SimpleOperation.parse((String)"sign");
        AuthorizationStrategy.get().checkAccess((IResource)resource, (IOperation)operation);
    }

    public static ISigner getSigner(IArgs args, String name) throws ObjectCreationException {
        return SignerTools.getSigner((InstanceSpec<ISigner>)InstanceSpec.get((IArgs)args, (String)name, ISigner.class, null));
    }

    public static ISigner getSigner(InstanceSpec<ISigner> spec) throws ObjectCreationException {
        ISigner signer = null;
        try {
            signer = SignerTools.getSignerRaw(spec);
            if (signer instanceof IAuthenticatedApplication) {
                IAuthenticatedApplication ia = (IAuthenticatedApplication)((Object)signer);
                ia.authenticate().get();
            }
            return signer;
        }
        catch (Exception e) {
            if (signer != null) {
                signer.dispose();
            }
            throw (ObjectCreationException)ExceptionTools.createTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    public static ISigner getSignerRaw(InstanceSpec<ISigner> spec) throws ObjectCreationException {
        try {
            if (spec == null) {
                return null;
            }
            return (ISigner)spec.createInstance();
        }
        catch (Exception e) {
            throw (ObjectCreationException)ExceptionTools.createTypedFromChain((Throwable)e, ObjectCreationException.class);
        }
    }

    public static IFactory[] lookupPreprocessorFactories() {
        return Outlet.get().lookupFactories(ISignerPreprocessor.class);
    }

    private SignerTools() {
    }
}

