/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.app.crypt.symmetric.common;

import de.intarsys.security.app.crypt.IKeyEncryptedData;
import de.intarsys.security.app.crypt.symmetric.common.AbstractCryptHandler;
import de.intarsys.security.app.crypt.symmetric.common.ISymmetricCryptHandler;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricDecryptorException;
import de.intarsys.security.app.crypt.symmetric.common.SymmetricEncryptorException;
import de.intarsys.security.device.common.CommonDevice;
import de.intarsys.tools.reflect.ObjectCreationException;
import javax.crypto.SecretKey;

public class FixedKeySymmetricCryptHandler
extends AbstractCryptHandler {
    private ISymmetricCryptHandler delegate;
    private SecretKey key;

    public FixedKeySymmetricCryptHandler(CommonDevice device, ISymmetricCryptHandler delegate) throws ObjectCreationException {
        super(device);
        this.delegate = delegate;
    }

    @Override
    public byte[] decrypt(IKeyEncryptedData encryptedData) throws SymmetricDecryptorException {
        return this.getDelegate().decrypt(encryptedData);
    }

    @Override
    public IKeyEncryptedData encrypt(byte[] data) throws SymmetricEncryptorException {
        return this.getDelegate().encrypt(data, this.getKey());
    }

    @Override
    public IKeyEncryptedData encrypt(byte[] data, SecretKey key) throws SymmetricEncryptorException {
        return this.getDelegate().encrypt(data, key);
    }

    @Override
    public SecretKey generateKey() throws SymmetricEncryptorException {
        if (this.key == null) {
            this.key = this.getDelegate().generateKey();
        }
        return this.key;
    }

    @Override
    public String getAlgorithmName() {
        return this.getDelegate().getAlgorithmName();
    }

    @Override
    public String getAlgorithmOID() {
        return this.getDelegate().getAlgorithmOID();
    }

    public ISymmetricCryptHandler getDelegate() {
        return this.delegate;
    }

    public SecretKey getKey() {
        return this.key;
    }

    @Override
    public String getKeyAlgorithm() {
        return this.getDelegate().getKeyAlgorithm();
    }

    @Override
    public int getKeyLength() {
        return this.getDelegate().getKeyLength();
    }

    @Override
    public SecretKey parseKey(byte[] key) throws SymmetricDecryptorException {
        return this.getDelegate().parseKey(key);
    }

    public void setKey(byte[] key) throws SymmetricDecryptorException {
        this.key = this.parseKey(key);
    }

    public void setKey(SecretKey key) {
        this.key = key;
    }
}

