/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.AbstractXRefParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STTrailerXRefSection;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class XRefFallbackParser
extends AbstractXRefParser {
    protected static final byte[] TOKEN_obj = "obj".getBytes();
    private STTrailerXRefSection xRefSection;
    private List trailers = new ArrayList();

    public XRefFallbackParser(STDocument doc, COSDocumentParser parser) {
        super(doc, parser);
        this.xRefSection = new STTrailerXRefSection(doc);
    }

    private void checkXRefSections() throws IOException, COSLoadException {
        if (this.trailers.isEmpty()) {
            COSLoadError e = new COSLoadError("no trailer found");
            this.handleError(e);
        }
        boolean rootFound = false;
        for (int i = this.trailers.size() - 1; i >= 0; --i) {
            COSDictionary trailer = (COSDictionary)this.trailers.get(i);
            if (!trailer.containsKey(COSTrailer.DK_Root)) continue;
            this.getXRefSection().cosSetDict(trailer);
            rootFound = true;
            break;
        }
        if (!rootFound) {
            COSLoadError e = new COSLoadError("trailer doesn't contain a root entry");
            this.handleError(e);
        }
        this.getXRefSection().setSize(this.getXRefSection().getMaxObjectNumber());
    }

    protected STTrailerXRefSection getXRefSection() {
        return this.xRefSection;
    }

    @Override
    public STXRefSection parse(IRandomAccess input) throws IOException, COSLoadException {
        input.seek(0L);
        while (this.readUptoNewLine(input)) {
            long offset = input.getOffset();
            try {
                COSDictionary trailer = this.getParser().parseTrailer(input);
                this.trailers.add(trailer);
            }
            catch (COSLoadException | IOException exception) {
                try {
                    int objNumber = this.getParser().readInt(input, true);
                    if (objNumber != 0) {
                        int genNumber = this.getParser().readInt(input, true);
                        byte[] token = this.getParser().readToken(input);
                        if (Arrays.equals(TOKEN_obj, token)) {
                            this.getXRefSection().addEntry(new STXRefEntryOccupied(objNumber, genNumber, offset));
                            continue;
                        }
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                input.seek(offset);
            }
        }
        this.checkXRefSections();
        return this.getXRefSection();
    }

    private boolean readUptoNewLine(IRandomAccess input) throws IOException {
        int i;
        do {
            if ((i = input.read()) != -1) continue;
            return false;
        } while (!PDFParser.isEOL(i));
        if (i == 13) {
            i = input.read();
            if (i == -1) {
                return false;
            }
            if (i != 10) {
                input.seekBy(-1L);
            }
        }
        return true;
    }
}

