/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.STXRefSubsection;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.Iterator;

public abstract class AbstractXRefWriter
implements IXRefEntryVisitor {
    public static final byte[] STARTXREF = "startxref".getBytes();
    private COSWriter cosWriter;
    private IRandomAccess randomAccess;

    protected AbstractXRefWriter(COSWriter cosWriter) {
        this.cosWriter = cosWriter;
    }

    protected void finish(STXRefSection xRefSection) throws IOException {
        this.writeStartXRef(xRefSection.getOffset());
    }

    public COSWriter getCosWriter() {
        return this.cosWriter;
    }

    protected IRandomAccess getRandomAccess() {
        return this.randomAccess;
    }

    protected abstract byte[] getTypeCompressed();

    protected abstract byte[] getTypeFree();

    protected abstract byte[] getTypeOccupied();

    protected void initialize(STXRefSection xRefSection) throws IOException {
        xRefSection.setOffset(this.getCosWriter().getRandomAccess().getOffset());
        int size = xRefSection.getMaxObjectNumber();
        if (xRefSection.getPrevious() != null) {
            size = Math.max(xRefSection.getPrevious().getSize(), size);
        }
        xRefSection.setSize(size);
    }

    protected void setRandomAccess(IRandomAccess randomAccess) {
        this.randomAccess = randomAccess;
    }

    @Override
    public void visitFromCompressed(STXRefEntryCompressed entry) throws XRefEntryVisitorException {
        try {
            this.write(entry.getStreamObjectNumber(), entry.getIndex(), this.getTypeCompressed());
        }
        catch (IOException e) {
            throw new XRefEntryVisitorException(e);
        }
    }

    @Override
    public void visitFromFree(STXRefEntryFree entry) throws XRefEntryVisitorException {
        try {
            this.write(entry.getNextFreeObjectNumber(), entry.getGenerationNumber(), this.getTypeFree());
        }
        catch (IOException e) {
            throw new XRefEntryVisitorException(e);
        }
    }

    @Override
    public void visitFromOccupied(STXRefEntryOccupied entry) throws XRefEntryVisitorException {
        try {
            this.write(entry.getOffset(), entry.getGenerationNumber(), this.getTypeOccupied());
        }
        catch (IOException e) {
            throw new XRefEntryVisitorException(e);
        }
    }

    protected void visitFromSection(STXRefSection xRefSection) throws IOException {
        Iterator i = xRefSection.subsectionIterator();
        while (i.hasNext()) {
            STXRefSubsection section = (STXRefSubsection)i.next();
            this.visitFromSubsection(section);
            Iterator ie = section.getEntries().iterator();
            while (ie.hasNext()) {
                try {
                    ((STXRefEntry)ie.next()).accept(this);
                }
                catch (XRefEntryVisitorException e) {
                    throw (IOException)e.getCause();
                }
            }
        }
    }

    protected abstract void visitFromSubsection(STXRefSubsection var1) throws IOException;

    protected abstract void write(long var1, int var3, byte[] var4) throws IOException;

    protected void writeStartXRef(long offset) throws IOException {
        this.getCosWriter().write(STARTXREF);
        this.getCosWriter().writeEOL();
        this.getCosWriter().write(StringTools.toByteArray((String)Long.toString(offset)));
        this.getCosWriter().writeEOL();
    }

    public void writeXRef(STXRefSection xRefSection) throws IOException {
        this.initialize(xRefSection);
        this.visitFromSection(xRefSection);
        this.finish(xRefSection);
    }
}

