/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;
import java.util.HashMap;
import java.util.Map;

public class PDResources
extends PDObject {
    public static final COSName CN_RT_ColorSpace = COSName.constant("ColorSpace");
    public static final COSName CN_RT_Encoding = COSName.constant("Encoding");
    public static final COSName CN_RT_ExtGState = COSName.constant("ExtGState");
    public static final COSName CN_RT_Font = COSName.constant("Font");
    public static final COSName CN_RT_Pattern = COSName.constant("Pattern");
    public static final COSName CN_RT_ProcSet = COSName.constant("ProcSet");
    public static final COSName CN_RT_Properties = COSName.constant("Properties");
    public static final COSName CN_RT_Shading = COSName.constant("Shading");
    public static final COSName CN_RT_XObject = COSName.constant("XObject");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private static Map resourceNamePrefixes = new HashMap();
    private Map currentCounters = new HashMap();
    private Map cachedResources = new HashMap();

    protected PDResources(COSObject object) {
        super(object);
    }

    public void addColorSpaceResource(COSName name, PDColorSpace colorSpace) {
        this.addResource(CN_RT_ColorSpace, name, colorSpace);
    }

    public void addExtGStateResource(COSName name, PDExtGState extGState) {
        this.addResource(CN_RT_ExtGState, name, extGState);
    }

    public void addFontResource(COSName name, PDFont font) {
        this.addResource(CN_RT_Font, name, font);
    }

    public void addPatternResource(COSName name, PDPattern pattern) {
        this.addResource(CN_RT_Pattern, name, pattern);
    }

    public void addResource(COSName resourceType, COSName name, PDObject object) {
        COSDictionary dict = this.cosGetResources(resourceType);
        if (dict == null) {
            dict = this.cosInitResources(resourceType);
        }
        dict.put(name, object.cosGetObject());
    }

    public void addShadingResource(COSName name, PDShading shading) {
        this.addResource(CN_RT_Shading, name, shading);
    }

    public void addXObjectResource(COSName name, PDXObject object) {
        this.addResource(CN_RT_XObject, name, object);
    }

    public void cosAddResource(COSName resourceType, COSName resourceName, COSObject resource) {
        COSDictionary dict = this.cosGetResources(resourceType);
        if (dict == null) {
            dict = this.cosInitResources(resourceType);
        }
        dict.put(resourceName, resource);
    }

    public COSName cosCreateResource(COSName resourceType, COSObject resource) {
        COSName key;
        COSDictionary resources = this.cosGetResources(resourceType);
        if (resources == null) {
            resources = this.cosInitResources(resourceType);
        }
        if ((key = resources.keyOf(resource).asName()) == null) {
            key = this.createResourceName(resourceType);
            resource = resource.copyOptional();
            resources.put(key, resource);
        }
        return key;
    }

    public COSObject cosGetResource(COSName resourceType, COSName resourceName) {
        COSDictionary resources = this.cosGetResources(resourceType);
        if (resources == null) {
            return COSNull.NULL;
        }
        return resources.get(resourceName);
    }

    public COSDictionary cosGetResources(COSName resourceType) {
        COSDictionary resources = (COSDictionary)this.cachedResources.get(resourceType);
        if (resources == null) {
            resources = this.cosGetField(resourceType).asDictionary();
            this.cachedResources.put(resourceType, resources);
        }
        return resources;
    }

    public COSDictionary cosInitResources(COSName resourceType) {
        COSDictionary resource = COSDictionary.create();
        this.cosSetField(resourceType, resource);
        return resource;
    }

    public void cosSetResources(COSName resourceType, COSDictionary resource) {
        this.cosSetField(resourceType, resource);
    }

    public COSName createColorSpaceResource(PDColorSpace colorSpace) {
        return this.createResource(CN_RT_ColorSpace, colorSpace);
    }

    public COSName createExtGStateResource(PDExtGState gstate) {
        return this.createResource(CN_RT_ExtGState, gstate);
    }

    public COSName createFontResource(PDFont font) {
        return this.createResource(CN_RT_Font, font);
    }

    public COSName createResource(COSName resourceType, PDObject object) {
        return this.cosCreateResource(resourceType, object.cosGetObject());
    }

    protected COSName createResourceName(COSName resourceType) {
        COSName newName;
        COSObject object;
        Integer count = (Integer)this.currentCounters.get(resourceType);
        if (count == null) {
            count = 0;
        }
        String prefix = (String)resourceNamePrefixes.get(resourceType);
        while (!(object = this.cosGetResource(resourceType, newName = COSName.create((prefix + (count = Integer.valueOf(count + 1))).getBytes()))).isNull()) {
        }
        this.currentCounters.put(resourceType, count);
        return newName;
    }

    public COSName createShadingResource(PDShading shading) {
        return this.createResource(CN_RT_Shading, shading);
    }

    public COSName createXObjectResource(PDXObject xobject) {
        return this.createResource(CN_RT_XObject, xobject);
    }

    public PDColorSpace getColorSpaceResource(COSName name) {
        return (PDColorSpace)this.getResource(CN_RT_ColorSpace, PDColorSpace.META, name);
    }

    public PDExtGState getExtGStateResource(COSName name) {
        return (PDExtGState)this.getResource(CN_RT_ExtGState, PDExtGState.META, name);
    }

    public PDFont getFontResource(COSName name) {
        return (PDFont)this.getResource(CN_RT_Font, PDFont.META, name);
    }

    public PDPattern getPatternResource(COSName name) {
        return (PDPattern)this.getResource(CN_RT_Pattern, PDPattern.META, name);
    }

    public PDObject getResource(COSName resourceType, PDObject.MetaClass metaClass, COSName name) {
        COSDictionary resources = this.cosGetResources(resourceType);
        if (resources == null) {
            return null;
        }
        return (PDObject)metaClass.createFromCos(resources.get(name));
    }

    public PDShading getShadingResource(COSName name) {
        return (PDShading)this.getResource(CN_RT_Shading, PDShading.META, name);
    }

    public PDXObject getXObjectResource(COSName name) {
        return (PDXObject)this.getResource(CN_RT_XObject, PDXObject.META, name);
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedResources.clear();
    }

    static {
        resourceNamePrefixes.put(CN_RT_ColorSpace, "CS");
        resourceNamePrefixes.put(CN_RT_ExtGState, "GS");
        resourceNamePrefixes.put(CN_RT_Font, "F");
        resourceNamePrefixes.put(CN_RT_Pattern, "P");
        resourceNamePrefixes.put(CN_RT_Shading, "S");
        resourceNamePrefixes.put(CN_RT_XObject, "X");
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class paramInstanceClass) {
            super(paramInstanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDResources(object);
        }
    }
}

