/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSTrue;
import de.intarsys.pdf.pd.AcroFormSigFlags;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAcroFormNode;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.pd.PDResources;
import java.util.List;

public class PDAcroForm
extends PDAcroFormNode {
    public static final COSName DK_Fields = COSName.constant("Fields");
    public static final COSName DK_NeedAppearances = COSName.constant("NeedAppearances");
    public static final COSName DK_SigFlags = COSName.constant("SigFlags");
    public static final COSName DK_CO = COSName.constant("CO");
    public static final COSName DK_XFA = COSName.constant("XFA");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private AcroFormSigFlags sigFlags;
    private List cachedFields;
    private boolean fieldsChecked = false;

    protected PDAcroForm(COSObject object) {
        super(object);
    }

    @Override
    public void addField(PDAcroFormField field) {
        this.checkFields();
        this.cosAddField(field.cosGetDict());
        field.setParent(null);
        if (field.isTypeSig()) {
            this.getSigFlags().setSignatureExists(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkFields() {
        PDAcroForm pDAcroForm = this;
        synchronized (pDAcroForm) {
            if (this.fieldsChecked) {
                return;
            }
            this.fieldsChecked = true;
            COSArray fields = this.cosGetField(DK_Fields).asArray();
            if (fields != null && fields.size() == 0) {
                COSArray cosFields = this.reconstruct(this.getDoc());
                this.cosGetDict().basicPutSilent(DK_Fields, cosFields);
            }
        }
    }

    private void cosAddField(COSDictionary field) {
        COSArray cosFields = this.cosGetField(DK_Fields).asArray();
        if (cosFields == null) {
            cosFields = COSArray.create();
            cosFields.beIndirect();
            this.cosSetField(DK_Fields, cosFields);
        }
        cosFields.add(field);
    }

    public COSObject cosGetXfa() {
        return this.cosGetField(DK_XFA);
    }

    protected void cosSetSigFlags(int newFlags) {
        if (newFlags != 0) {
            this.cosSetField(DK_SigFlags, COSInteger.create(newFlags));
        } else {
            this.cosRemoveField(DK_SigFlags);
        }
    }

    @Override
    public PDAcroForm getAcroForm() {
        return this;
    }

    public List getCalculationOrder() {
        return this.getPDObjects(DK_CO, PDAcroFormField.META, false);
    }

    public PDResources getDefaultResources() {
        return (PDResources)PDResources.META.createFromCos(this.cosGetField(DK_DR));
    }

    public List getFields() {
        this.checkFields();
        if (this.cachedFields == null) {
            this.cachedFields = this.getPDObjects(DK_Fields, PDAcroFormField.META, true);
        }
        return this.cachedFields;
    }

    @Override
    public List getGenericChildren() {
        return this.getFields();
    }

    public boolean getNeedAppearances() {
        return this.getFieldBoolean(DK_NeedAppearances, false);
    }

    public AcroFormSigFlags getSigFlags() {
        if (this.sigFlags == null) {
            this.sigFlags = new AcroFormSigFlags(this);
        }
        return this.sigFlags;
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        COSArray cosFields = this.cosGetField(DK_Fields).asArray();
        if (cosFields != null) {
            cosFields.removeObjectListener(this);
        }
        this.cachedFields = null;
    }

    public boolean isSignatureExists() {
        for (PDAcroFormField field : this.collectLeafFields()) {
            if (!field.isTypeSig()) continue;
            return true;
        }
        return false;
    }

    public boolean isSigned() {
        for (PDAcroFormField field : this.collectLeafFields()) {
            if (!field.isTypeSig() || !((PDAFSignatureField)field).isSigned()) continue;
            return true;
        }
        return false;
    }

    protected COSArray reconstruct(PDDocument doc) {
        COSArray result = COSArray.create();
        if (doc == null) {
            return result;
        }
        PDPageTree pageTree = doc.getPageTree();
        if (pageTree == null) {
            return result;
        }
        boolean signatureExists = false;
        for (PDPage page = pageTree.getFirstPage(); page != null; page = page.getNextPage()) {
            List<PDAnnotation> annotations = page.getAnnotations();
            if (annotations == null) continue;
            for (PDAnnotation annot : annotations) {
                if (!annot.isWidgetAnnotation()) continue;
                COSDictionary cosAnnot = annot.cosGetDict();
                result.basicAddSilent(cosAnnot);
                cosAnnot.basicRemoveSilent(PDAcroFormField.DK_Parent);
                signatureExists |= cosAnnot.get(PDAcroFormField.DK_FT).equals(PDAcroFormField.CN_FT_Sig);
            }
        }
        if (signatureExists) {
            int flags = this.getFieldInt(DK_SigFlags, 0);
            this.cosGetDict().basicPutSilent(DK_SigFlags, COSInteger.create(flags |= 3));
        }
        return result;
    }

    @Override
    public boolean removeField(PDAcroFormField field) {
        this.getFields().remove(field);
        COSArray cosFields = this.cosGetField(DK_Fields).asArray();
        if (cosFields == null) {
            return false;
        }
        boolean removed = cosFields.remove(field.cosGetDict());
        this.getSigFlags().setSignatureExists(this.isSignatureExists());
        return removed;
    }

    protected void setCalculationOrder(List newCalculationOrder) {
        this.setPDObjects(DK_CO, newCalculationOrder);
    }

    public void setDefaultResources(PDResources newResources) {
        this.setFieldObject(DK_DR, newResources);
    }

    @Override
    public void setGenericParent(PDObject parent) {
        throw new IllegalStateException("AcroForm may not have a parent");
    }

    public void setNeedAppearances(boolean newNeedAppearances) {
        if (newNeedAppearances) {
            this.cosSetField(DK_NeedAppearances, COSTrue.create());
        } else {
            this.cosRemoveField(DK_NeedAppearances);
        }
    }

    @Override
    public String toString() {
        return "AcroForm " + super.toString();
    }

    public static class MetaClass
    extends PDAcroFormNode.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDAcroForm(object);
        }

        @Override
        protected MetaClass doDetermineClass(COSObject object) {
            if (!(object instanceof COSDictionary)) {
                return null;
            }
            return this;
        }
    }
}

