/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.pd.AbstractBitFlags;
import de.intarsys.pdf.pd.PDAcroFormField;

public class AcroFormFieldFlags
extends AbstractBitFlags {
    public static final int Bit_ReadOnly = 1;
    public static final int Bit_Required = 2;
    public static final int Bit_NoExport = 4;
    public static final int Bit_Multiline = 4096;
    public static final int Bit_Password = 8192;
    public static final int Bit_NoToggleToOff = 16384;
    public static final int Bit_Radio = 32768;
    public static final int Bit_Pushbutton = 65536;
    public static final int Bit_Combo = 131072;
    public static final int Bit_Edit = 262144;
    public static final int Bit_Sort = 524288;
    public static final int Bit_FileSelect = 0x100000;
    public static final int Bit_MultiSelect = 0x200000;
    public static final int Bit_DoNotSpellCheck = 0x400000;
    public static final int Bit_DoNotScroll = 0x800000;
    public static final int Bit_Comb = 0x1000000;
    public static final int Bit_RadiosInUnison = 0x2000000;
    public static final int Bit_CommitOnSelChange = 0x4000000;
    public static final int Bit_RichText = 0x8000000;
    private PDAcroFormField field;

    public AcroFormFieldFlags(int value) {
        super(value);
    }

    public AcroFormFieldFlags(PDAcroFormField field) {
        super(field, null);
        this.field = field;
    }

    protected PDAcroFormField getField() {
        return this.field;
    }

    @Override
    protected int getValueInObject() {
        return this.getField().basicGetFieldFlags();
    }

    public boolean isComb() {
        return this.isSetAnd(0x1000000);
    }

    public boolean isCombo() {
        return this.isSetAnd(131072);
    }

    public boolean isCommitOnSelChange() {
        return this.isSetAnd(0x4000000);
    }

    public boolean isDoNotScroll() {
        return this.isSetAnd(0x800000);
    }

    public boolean isEdit() {
        return this.isSetAnd(262144);
    }

    public boolean isFileSelect() {
        return this.isSetAnd(0x100000);
    }

    public boolean isMultiline() {
        return this.isSetAnd(4096);
    }

    public boolean isMultiSelect() {
        return this.isSetAnd(0x200000);
    }

    public boolean isNoExport() {
        return this.isSetAnd(4);
    }

    public boolean isNoToggleOff() {
        return this.isSetAnd(16384);
    }

    public boolean isPassword() {
        return this.isSetAnd(8192);
    }

    public boolean isPushbutton() {
        return this.isSetAnd(65536);
    }

    public boolean isRadio() {
        return this.isSetAnd(32768);
    }

    public boolean isRadiosInUnison() {
        return this.isSetAnd(0x2000000);
    }

    public boolean isReadOnly() {
        return this.isSetAnd(1);
    }

    public boolean isRequired() {
        return this.isSetAnd(2);
    }

    @Override
    public void set(int bitMask, boolean flag) {
        super.set(bitMask, flag);
        if (this.getField() != null && this.getField().getKids() != null) {
            for (PDAcroFormField kid : this.getField().getKids()) {
                kid.getFieldFlags().set(bitMask, flag);
            }
        }
    }

    public void setComb(boolean f) {
        this.set(0x1000000, f);
    }

    public void setCombo(boolean f) {
        this.set(131072, f);
    }

    public void setCommitOnSelChange(boolean f) {
        this.set(0x4000000, f);
    }

    public void setDoNotScroll(boolean f) {
        this.set(0x800000, f);
    }

    public void setEdit(boolean edit) {
        this.set(262144, edit);
    }

    public void setFileSelect(boolean f) {
        this.set(0x100000, f);
    }

    public void setMultiline(boolean f) {
        this.set(4096, f);
    }

    public void setMultiSelect(boolean multiSelect) {
        this.set(0x200000, multiSelect);
    }

    public void setNoExport(boolean f) {
        this.set(4, f);
    }

    public void setNoToggleToOff(boolean noToggleToOff) {
        this.set(16384, noToggleToOff);
    }

    public void setPassword(boolean f) {
        this.set(8192, f);
    }

    public void setPushbutton(boolean f) {
        this.set(65536, f);
    }

    public void setRadio(boolean f) {
        this.set(32768, f);
    }

    public void setReadOnly(boolean f) {
        this.set(1, f);
    }

    public void setRequired(boolean f) {
        this.set(2, f);
    }

    @Override
    protected void setValueInObject(int newValue) {
        this.getField().basicSetFieldFlags(newValue);
    }
}

