/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;

public abstract class AbstractBitFlags {
    private int value;
    private COSBasedObject object;
    private COSName field;

    protected AbstractBitFlags(COSBasedObject object, COSName field) {
        this.object = object;
        this.field = field;
    }

    protected AbstractBitFlags(int value) {
        this.value = value;
    }

    public final int getValue() {
        if (this.object == null) {
            return this.value;
        }
        return this.getValueInObject();
    }

    protected int getValueInObject() {
        return this.object.getFieldInt(this.field, 0);
    }

    public boolean isSetAnd(int bitMask) {
        return (this.getValue() & bitMask) == bitMask;
    }

    public boolean isSetOr(int bitMask) {
        return (this.getValue() & bitMask) != 0;
    }

    public void set(int bitMask, boolean flag) {
        if (flag) {
            this.setValue(this.getValue() | bitMask);
        } else {
            this.setValue(this.getValue() & (0xFFFFFFFF ^ bitMask));
        }
    }

    public final void setValue(int newValue) {
        if (this.object == null) {
            this.value = newValue;
        } else {
            this.setValueInObject(newValue);
        }
    }

    protected void setValueInObject(int newValue) {
        this.object.setFieldInt(this.field, newValue);
    }
}

