/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.tools.exception.UnreachableCodeError;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ToUnicodeCreator {
    private static final int DEFLATE_THRESHOLD = 100;
    private static final int MAX_OPERANDS_PER_OPERATOR = 100;

    public COSStream createCMap(Map<Integer, Integer> cidToUnicode) {
        byte[] content = this.createCMapContent(cidToUnicode);
        COSStream cmap = COSStream.create(null);
        cmap.setDecodedBytes(content);
        if (content.length > 100) {
            cmap.addFilter(Filter.CN_Filter_FlateDecode);
        }
        return cmap;
    }

    public byte[] createCMapContent(Map<Integer, Integer> cidToUnicode) {
        ArrayList<Single> singles = new ArrayList<Single>();
        ArrayList<Range> ranges = new ArrayList<Range>();
        int cidStart = -1;
        int unicodeStart = -1;
        int length = -1;
        for (Map.Entry<Integer, Integer> entry : new TreeMap<Integer, Integer>(cidToUnicode).entrySet()) {
            int cid = entry.getKey();
            int unicode = entry.getValue();
            if (length != -1 && cid == cidStart + length && unicode == unicodeStart + length && (cid & 0xFF) != 0) {
                ++length;
                continue;
            }
            if (length == 1) {
                singles.add(new Single(cidStart, unicodeStart));
            } else if (length > 1) {
                ranges.add(new Range(cidStart, unicodeStart, length));
            }
            cidStart = cid;
            unicodeStart = unicode;
            length = 1;
        }
        if (length == 1) {
            singles.add(new Single(cidStart, unicodeStart));
        } else if (length > 1) {
            ranges.add(new Range(cidStart, unicodeStart, length));
        }
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)content, StandardCharsets.US_ASCII);){
            ((Writer)writer).append("/CIDInit /ProcSet findresource begin\n12 dict begin\nbegincmap\n/CIDSystemInfo\n<< /Registry (Adobe)\n/Ordering (UCS)\n/Supplement 0\n>> def\n/CMapName /Adobe-Identity-UCS def\n/CMapType 2 def\n1 begincodespacerange\n<0000> <FFFF>\nendcodespacerange\n");
            for (List batch : this.partition(singles, 100)) {
                ((Writer)writer).append(String.format("%d beginbfchar\n", batch.size()));
                for (Single single : batch) {
                    ((Writer)writer).append(String.format("<%04X> <%04X>\n", single.cid(), single.unicode()));
                }
                ((Writer)writer).append("endbfchar\n");
            }
            for (List batch : this.partition(ranges, 100)) {
                ((Writer)writer).append(String.format("%d beginbfrange\n", batch.size()));
                for (Range range : batch) {
                    ((Writer)writer).append(String.format("<%04X> <%04X> <%04X>\n", range.cidStart(), range.cidStart() + range.length() - 1, range.unicodeStart()));
                }
                ((Writer)writer).append("endbfrange\n");
            }
            ((Writer)writer).append("endcmap\nCMapName currentdict /CMap defineresource pop\nend\nend\n");
        }
        catch (IOException exception) {
            throw new UnreachableCodeError("Should never happen writing to a ByteArrayOutputStream", (Throwable)exception);
        }
        return content.toByteArray();
    }

    private <T> List<List<T>> partition(List<T> list, int maxBatchSize) {
        ArrayList<List<T>> partitions = new ArrayList<List<T>>();
        int from = 0;
        int size = list.size();
        while (from < size) {
            int to = Math.min(from + maxBatchSize, size);
            partitions.add(list.subList(from, to));
            from = to;
        }
        return partitions;
    }

    private record Single(int cid, int unicode) {
    }

    private record Range(int cidStart, int unicodeStart, int length) {
    }
}

