/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.cwt.font.afm.AFM;
import de.intarsys.cwt.font.afm.AFMChar;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.SymbolEncoding;
import de.intarsys.pdf.font.AFMEncoding;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorAFM;
import de.intarsys.pdf.font.PDSingleByteFont;
import de.intarsys.tools.locator.ClassResourceLocator;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFontType1
extends PDSingleByteFont {
    private static final Logger Log = LoggerFactory.getLogger(PDFontType1.class);
    public static final Map<String, String> FONT_ALIASES;
    public static final Map<String, String> FONT_ALIASES_DEPRECATED;
    public static final String FONT_Courier = "Courier";
    public static final String FONT_Courier_Bold = "Courier-Bold";
    public static final String FONT_Courier_BoldOblique = "Courier-BoldOblique";
    public static final String FONT_Courier_Oblique = "Courier-Oblique";
    public static final String FONT_Helvetica = "Helvetica";
    public static final String FONT_Helvetica_Bold = "Helvetica-Bold";
    public static final String FONT_Helvetica_BoldOblique = "Helvetica-BoldOblique";
    public static final String FONT_Helvetica_Oblique = "Helvetica-Oblique";
    public static final String FONT_Symbol = "Symbol";
    public static final String FONT_Times_Bold = "Times-Bold";
    public static final String FONT_Times_BoldItalic = "Times-BoldItalic";
    public static final String FONT_Times_Italic = "Times-Italic";
    public static final String FONT_Times_Roman = "Times-Roman";
    public static final String FONT_ZapfDingbats = "ZapfDingbats";
    protected static final String[] FONT_BUILTINS;
    public static final MetaClass META;
    private static final Map<String, AFM> BUILTINS;

    public static PDFontType1 createNew(String name) {
        PDFontType1 font = (PDFontType1)META.createNew();
        String baseFontName = FONT_ALIASES.get(name);
        if (baseFontName == null && (baseFontName = FONT_ALIASES_DEPRECATED.get(name)) == null) {
            baseFontName = name;
        }
        font.setBaseFont(baseFontName);
        return font;
    }

    public static boolean isBuiltin(String name) {
        return name != null && name.equals(FONT_ALIASES.get(name));
    }

    public static boolean isBuiltinAlias(String name) {
        return FONT_ALIASES.get(name) != null;
    }

    public static boolean isBuiltinDeprecated(String name) {
        return FONT_ALIASES_DEPRECATED.get(name) != null;
    }

    public static synchronized AFM lookupBuiltinAFM(String name) {
        String aliased = FONT_ALIASES.get(name);
        if (aliased == null && (aliased = FONT_ALIASES_DEPRECATED.get(name)) == null) {
            return null;
        }
        return BUILTINS.computeIfAbsent(aliased, tmp -> {
            ClassResourceLocator locator = new ClassResourceLocator(PDFontType1.class, tmp + ".afm");
            try {
                return AFM.createFromLocator((ILocator)locator);
            }
            catch (IOException e) {
                Log.warn("builtin font metrics '" + tmp + "' load error", (Throwable)e);
                return null;
            }
        });
    }

    protected PDFontType1(COSObject object) {
        super(object);
    }

    @Override
    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Type1;
    }

    @Override
    protected PDFontDescriptor createBuiltinFontDescriptor() {
        return new PDFontDescriptorAFM(PDFontType1.lookupBuiltinAFM(this.getBaseFont().stringValue()));
    }

    @Override
    protected float[] createBuiltInWidths(float[] result) {
        AFM afm = PDFontType1.lookupBuiltinAFM(this.getBaseFont().stringValue());
        if (afm == null) {
            return result;
        }
        if (this.getEncoding().isFontSpecificEncoding()) {
            for (int i = 0; i < 256; ++i) {
                AFMChar afmChar = afm.getCharByCode(i);
                if (afmChar == null) continue;
                result[i] = afmChar.getWidth();
            }
        } else {
            for (int i = 0; i < 256; ++i) {
                String glyphName = this.getEncoding().getGlyphName(i);
                AFMChar afmChar = afm.getCharByName(glyphName);
                if (afmChar == null) continue;
                result[i] = afmChar.getWidth();
            }
        }
        return result;
    }

    @Override
    protected Encoding createDefaultEncoding() {
        if (this.getFontDescriptor() != null && this.getFontDescriptor().isSymbolic()) {
            return SymbolEncoding.UNIQUE;
        }
        AFM afm = PDFontType1.lookupBuiltinAFM(this.getBaseFont().stringValue());
        if (afm == null) {
            return super.createDefaultEncoding();
        }
        return new AFMEncoding(afm);
    }

    @Override
    protected int createFirstChar() {
        Encoding encoding = this.getEncoding();
        for (int i = 0; i <= 255; ++i) {
            if (encoding.getDecoded(i) == -1) continue;
            return i;
        }
        return 0;
    }

    @Override
    protected int createLastChar() {
        Encoding encoding = this.getEncoding();
        for (int i = 255; i >= 0; --i) {
            if (encoding.getDecoded(i) == -1) continue;
            return i;
        }
        return 0;
    }

    @Override
    public String getFontNameNormalized() {
        String name = super.getFontNameNormalized();
        String alias = FONT_ALIASES.get(name);
        if (alias != null) {
            return alias;
        }
        alias = FONT_ALIASES_DEPRECATED.get(name);
        if (alias != null) {
            return alias;
        }
        return name;
    }

    @Override
    public String getFontType() {
        return "Type1";
    }

    @Override
    public boolean isStandardFont() {
        if (this.cosGetField(DK_FontDescriptor).isNull()) {
            return true;
        }
        String baseFontName = this.cosGetField(DK_BaseFont).getValueString(null);
        return Arrays.asList(FONT_BUILTINS).contains(baseFontName);
    }

    static {
        FONT_BUILTINS = new String[]{FONT_Courier, FONT_Courier_Bold, FONT_Courier_BoldOblique, FONT_Courier_Oblique, FONT_Helvetica, FONT_Helvetica_Bold, FONT_Helvetica_BoldOblique, FONT_Helvetica_Oblique, FONT_Symbol, FONT_Times_Bold, FONT_Times_BoldItalic, FONT_Times_Italic, FONT_Times_Roman, FONT_ZapfDingbats};
        META = new MetaClass(MetaClass.class.getDeclaringClass());
        BUILTINS = new HashMap<String, AFM>();
        HashMap<String, String> tmpAliases = new HashMap<String, String>();
        tmpAliases.put(FONT_Courier, FONT_Courier);
        tmpAliases.put(FONT_Courier_Bold, FONT_Courier_Bold);
        tmpAliases.put(FONT_Courier_Oblique, FONT_Courier_Oblique);
        tmpAliases.put(FONT_Courier_BoldOblique, FONT_Courier_BoldOblique);
        tmpAliases.put(FONT_Helvetica, FONT_Helvetica);
        tmpAliases.put(FONT_Helvetica_Bold, FONT_Helvetica_Bold);
        tmpAliases.put(FONT_Helvetica_Oblique, FONT_Helvetica_Oblique);
        tmpAliases.put(FONT_Helvetica_BoldOblique, FONT_Helvetica_BoldOblique);
        tmpAliases.put(FONT_Times_Roman, FONT_Times_Roman);
        tmpAliases.put(FONT_Times_Bold, FONT_Times_Bold);
        tmpAliases.put(FONT_Times_Italic, FONT_Times_Italic);
        tmpAliases.put(FONT_Times_BoldItalic, FONT_Times_BoldItalic);
        tmpAliases.put(FONT_ZapfDingbats, FONT_ZapfDingbats);
        tmpAliases.put(FONT_Symbol, FONT_Symbol);
        tmpAliases.put("Cour", FONT_Courier);
        tmpAliases.put("CoBo", FONT_Courier_Bold);
        tmpAliases.put("CoOb", FONT_Courier_Oblique);
        tmpAliases.put("CoBO", FONT_Courier_BoldOblique);
        tmpAliases.put("Helv", FONT_Helvetica);
        tmpAliases.put("HeBo", FONT_Helvetica_Bold);
        tmpAliases.put("HeOb", FONT_Helvetica_Oblique);
        tmpAliases.put("HeBO", FONT_Helvetica_BoldOblique);
        tmpAliases.put("TiRo", FONT_Times_Roman);
        tmpAliases.put("TiBo", FONT_Times_Bold);
        tmpAliases.put("TiIt", FONT_Times_Italic);
        tmpAliases.put("TiBI", FONT_Times_BoldItalic);
        tmpAliases.put("ZaDb", FONT_ZapfDingbats);
        tmpAliases.put("Symb", FONT_Symbol);
        tmpAliases.put("CourierNew", FONT_Courier);
        tmpAliases.put("CourierNew,Bold", FONT_Courier_Bold);
        tmpAliases.put("CourierNew,Italic", FONT_Courier_Oblique);
        tmpAliases.put("CourierNew,BoldItalic", FONT_Courier_BoldOblique);
        tmpAliases.put("Arial", FONT_Helvetica);
        tmpAliases.put("Arial,Bold", FONT_Helvetica_Bold);
        tmpAliases.put("Arial,Italic", FONT_Helvetica_Oblique);
        tmpAliases.put("Arial,BoldItalic", FONT_Helvetica_BoldOblique);
        tmpAliases.put("TimesNewRoman", FONT_Times_Roman);
        tmpAliases.put("TimesNewRoman,Bold", FONT_Times_Bold);
        tmpAliases.put("TimesNewRoman,Italic", FONT_Times_Italic);
        tmpAliases.put("TimesNewRoman,BoldItalic", FONT_Times_BoldItalic);
        FONT_ALIASES = Collections.unmodifiableMap(tmpAliases);
        HashMap<String, String> tmpDeprecated = new HashMap<String, String>();
        tmpDeprecated.put("TimesNewRomanPS", FONT_Times_Roman);
        tmpDeprecated.put("TimesNewRomanPSMT", FONT_Times_Roman);
        tmpDeprecated.put("TimesNewRoman-Bold", FONT_Times_Bold);
        tmpDeprecated.put("TimesNewRomanPS-Bold", FONT_Times_Bold);
        tmpDeprecated.put("TimesNewRomanPS-BoldMT", FONT_Times_Bold);
        tmpDeprecated.put("TimesNewRoman-Italic", FONT_Times_Italic);
        tmpDeprecated.put("TimesNewRomanPS-Italic", FONT_Times_Italic);
        tmpDeprecated.put("TimesNewRomanPS-ItalicMT", FONT_Times_Italic);
        tmpDeprecated.put("TimesNewRoman-BoldItalic", FONT_Times_BoldItalic);
        tmpDeprecated.put("TimesNewRomanPS-BoldItalic", FONT_Times_BoldItalic);
        tmpDeprecated.put("TimesNewRomanPS-BoldItalicMT", FONT_Times_BoldItalic);
        tmpDeprecated.put("CourierNewPSMT", FONT_Courier);
        tmpDeprecated.put("Courier,BoldItalic", FONT_Courier_BoldOblique);
        tmpDeprecated.put("CourierNew-BoldItalic", FONT_Courier_BoldOblique);
        tmpDeprecated.put("CourierNewPS-BoldItalicMT", FONT_Courier_BoldOblique);
        tmpDeprecated.put("Courier,Bold", FONT_Courier_Bold);
        tmpDeprecated.put("CourierNew-Bold", FONT_Courier_Bold);
        tmpDeprecated.put("CourierNewPS-BoldMT", FONT_Courier_Bold);
        tmpDeprecated.put("Courier,Italic", FONT_Courier_Oblique);
        tmpDeprecated.put("CourierNew-Italic", FONT_Courier_Oblique);
        tmpDeprecated.put("CourierNewPS-ItalicMT", FONT_Courier_Oblique);
        tmpDeprecated.put("Helvetica,Bold", FONT_Helvetica_Bold);
        tmpDeprecated.put("Helvetica-Italic", FONT_Helvetica_Oblique);
        tmpDeprecated.put("Helvetica,Italic", FONT_Helvetica_Oblique);
        tmpDeprecated.put("Helvetica-BoldItalic", FONT_Helvetica_BoldOblique);
        tmpDeprecated.put("Helvetica,BoldItalic", FONT_Helvetica_BoldOblique);
        tmpDeprecated.put("ArialMT", FONT_Helvetica);
        tmpDeprecated.put("Arial-Bold", FONT_Helvetica_Bold);
        tmpDeprecated.put("Arial-BoldMT", FONT_Helvetica_Bold);
        tmpDeprecated.put("Arial-Italic", FONT_Helvetica_Oblique);
        tmpDeprecated.put("Arial-ItalicMT", FONT_Helvetica_Oblique);
        tmpDeprecated.put("Arial-BoldItalic", FONT_Helvetica_BoldOblique);
        tmpDeprecated.put("Arial-BoldItalicMT", FONT_Helvetica_BoldOblique);
        FONT_ALIASES_DEPRECATED = Collections.unmodifiableMap(tmpDeprecated);
    }

    public static class MetaClass
    extends PDFont.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDFontType1(object);
        }
    }
}

