/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.filter.ASCII85Filter;
import de.intarsys.pdf.filter.ASCIIHexFilter;
import de.intarsys.pdf.filter.CCITTFaxFilter;
import de.intarsys.pdf.filter.CryptFilter;
import de.intarsys.pdf.filter.DCTFilter;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.filter.FlateFilter;
import de.intarsys.pdf.filter.IFilter;
import de.intarsys.pdf.filter.IFilterFactory;
import de.intarsys.pdf.filter.JBIG2Filter;
import de.intarsys.pdf.filter.JPXFilter;
import de.intarsys.pdf.filter.LZWFilter;
import de.intarsys.pdf.filter.RunLengthFilter;
import java.io.IOException;

public class StandardFilterFactory
implements IFilterFactory {
    @Override
    public IFilter createFilter(COSName filterName, COSDictionary options) throws IOException {
        Filter result = null;
        if (filterName.equals(Filter.CN_Filter_FlateDecode)) {
            result = new FlateFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_Fl)) {
            result = new FlateFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_ASCIIHexDecode)) {
            result = new ASCIIHexFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_AHx)) {
            result = new ASCIIHexFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_ASCII85Decode)) {
            result = new ASCII85Filter(options);
        } else if (filterName.equals(Filter.CN_Filter_A85)) {
            result = new ASCII85Filter(options);
        } else if (filterName.equals(Filter.CN_Filter_LZWDecode)) {
            result = new LZWFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_LZW)) {
            result = new LZWFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_RunLengthDecode)) {
            result = new RunLengthFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_RL)) {
            result = new RunLengthFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_CCITTFaxDecode)) {
            result = new CCITTFaxFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_CCF)) {
            result = new CCITTFaxFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_JBIG2Decode)) {
            result = new JBIG2Filter(options);
        } else if (filterName.equals(Filter.CN_Filter_DCTDecode)) {
            result = new DCTFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_DCT)) {
            result = new DCTFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_JPXDecode)) {
            result = new JPXFilter(options);
        } else if (filterName.equals(Filter.CN_Filter_Crypt)) {
            result = new CryptFilter(options);
        }
        if (result == null) {
            throw new IOException("unknown filter:" + filterName);
        }
        return result;
    }
}

