/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.filter.CCITTFaxDecoder;
import de.intarsys.pdf.filter.Filter;

public class CCITTFaxFilter
extends Filter {
    public static final COSName DK_BlackIs1 = COSName.constant("BlackIs1");
    public static final COSName DK_Columns = COSName.constant("Columns");
    public static final COSName DK_DamagedRowsBeforeError = COSName.constant("DamagedRowsBeforeError");
    public static final COSName DK_EncodedByteAlign = COSName.constant("EncodedByteAlign");
    public static final COSName DK_EndOfBlock = COSName.constant("EndOfBlock");
    public static final COSName DK_EndOfLine = COSName.constant("EndOfLine");
    public static final COSName DK_H = COSName.constant("H");
    public static final COSName DK_Height = COSName.constant("Height");
    public static final COSName DK_K = COSName.constant("K");
    public static final COSName DK_Rows = COSName.constant("Rows");
    public static final COSName DK_W = COSName.constant("W");
    public static final COSName DK_Width = COSName.constant("Width");

    public CCITTFaxFilter(COSDictionary options) {
        super(options);
    }

    @Override
    protected byte[] decode(byte[] source) {
        int width = 1728;
        COSInteger widthDef = this.getStream().getDict().get(DK_Width).asInteger();
        if (widthDef == null) {
            widthDef = this.getStream().getDict().get(DK_W).asInteger();
        }
        if (widthDef != null) {
            width = widthDef.intValue();
        }
        int height = 0;
        COSInteger heightDef = this.getStream().getDict().get(DK_Height).asInteger();
        if (heightDef == null) {
            heightDef = this.getStream().getDict().get(DK_H).asInteger();
        }
        if (heightDef != null) {
            height = heightDef.intValue();
        }
        int columns = this.getOption(DK_Columns).getValueInteger(width);
        int rows = this.getOption(DK_Rows).getValueInteger(height);
        int k = this.getOption(DK_K).getValueInteger(0);
        int size = rows * (columns + 7 >> 3);
        byte[] destination = new byte[size];
        boolean align = this.getOption(DK_EncodedByteAlign).getValueBoolean(false);
        CCITTFaxDecoder decoder = new CCITTFaxDecoder(1, columns, rows);
        decoder.setAlign(align);
        if (k == 0) {
            decoder.decodeT41D(destination, source, 0, rows);
        } else if (k > 0) {
            decoder.decodeT42D(destination, source, 0, rows);
        } else if (k < 0) {
            decoder.decodeT6(destination, source, 0, rows);
        }
        if (!this.getOption(DK_BlackIs1).getValueBoolean(false)) {
            for (int i = 0; i < destination.length; ++i) {
                destination[i] = ~destination[i];
            }
        }
        return destination;
    }

    @Override
    protected byte[] encode(byte[] source) {
        return null;
    }
}

