/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSConverter;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.locator.LocatorViewport;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class COSTools {
    private static final Logger Log = LoggerFactory.getLogger(COSTools.class);
    protected static final byte[] TOKEN_EOF = "%%EOF".getBytes();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean canParse(Revision revision, COSDocument hostDoc) {
        STDocument doc = null;
        try {
            HashMap<String, ISystemSecurityHandler> options = new HashMap<String, ISystemSecurityHandler>();
            options.put("systemSecurityHandler", hostDoc.stGetDoc().getReadSecurityHandler());
            doc = STDocument.createFromLocator(revision.createLocator(), options);
            boolean bl = true;
            return bl;
        }
        catch (COSLoadException | IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (doc != null) {
                try {
                    doc.close();
                }
                catch (IOException e) {
                    Log.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    @Deprecated
    public static COSObject createObject(Object javaObject) {
        return COSConverter.toCos(javaObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IRevision> getRevisions(COSDocument doc) throws IOException, COSLoadException {
        ArrayList<IRevision> result = new ArrayList<IRevision>();
        STDocument stDoc = doc.stGetDoc();
        IRandomAccess randomAccess = stDoc.getLocator().getRandomAccess();
        if (randomAccess == null) {
            return result;
        }
        try {
            ArrayList<STXRefSection> offsetSortedXRefs = new ArrayList<STXRefSection>();
            for (STXRefSection xRef = stDoc.getXRefSection(); xRef != null; xRef = xRef.getPrevious()) {
                offsetSortedXRefs.add(xRef);
            }
            Collections.sort(offsetSortedXRefs, (o1, o2) -> {
                if (o1.getOffset() < o2.getOffset()) {
                    return 1;
                }
                if (o1.getOffset() > o2.getOffset()) {
                    return -1;
                }
                return 0;
            });
            long lastEnd = -1L;
            for (STXRefSection section : offsetSortedXRefs) {
                long end;
                long limit = lastEnd;
                if (limit == -1L) {
                    limit = randomAccess.getLength();
                }
                if ((end = COSTools.searchNextEOF(randomAccess, section.getOffset(), limit)) == -1L) {
                    end = randomAccess.getLength();
                }
                Revision revision = new Revision();
                revision.setXRefSection(section);
                revision.setLength(end);
                result.add(revision);
                lastEnd = end;
            }
        }
        finally {
            randomAccess.close();
        }
        Collections.reverse(result);
        if (result.size() > 1 && (doc.stGetDoc().isLinearized() || !COSTools.canParse((Revision)result.get(0), doc))) {
            LinearizedRevision linearizedRevision = new LinearizedRevision((IRevision)result.remove(0), (IRevision)result.remove(0));
            result.add(0, linearizedRevision);
        }
        return result;
    }

    public static List<IRevision> getSubsequentRevisions(COSDocument doc, IRevision base) throws IOException, COSLoadException {
        List<IRevision> revisions = COSTools.getRevisions(doc);
        ArrayList<IRevision> result = new ArrayList<IRevision>();
        boolean include = false;
        for (IRevision revision : revisions) {
            if (include) {
                result.add(revision);
                continue;
            }
            if (!revision.equals(base)) continue;
            include = true;
        }
        return result;
    }

    public static List<ILocator> getVersions(COSDocument doc) throws IOException, COSLoadException {
        List<IRevision> revisions = COSTools.getRevisions(doc);
        ArrayList<ILocator> result = new ArrayList<ILocator>();
        for (IRevision revision : revisions) {
            result.add(revision.createLocator());
        }
        return result;
    }

    protected static boolean readUptoNewLine(IRandomAccess input) throws IOException {
        int i;
        do {
            if ((i = input.read()) != -1) continue;
            return false;
        } while (!PDFParser.isEOL(i));
        if (i == 13 && (i = input.read()) != 10 && i != -1) {
            input.seekBy(-1L);
        }
        return true;
    }

    protected static long searchNextEOF(IRandomAccess input, long start, long end) throws IOException, COSLoadException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        input.seek(start);
        int comparisonIndex = 0;
        int i = input.read();
        while (i != -1 && input.getOffset() <= end) {
            bos.write(i);
            if (i == TOKEN_EOF[comparisonIndex]) {
                if (++comparisonIndex == TOKEN_EOF.length) {
                    COSTools.readUptoNewLine(input);
                    return input.getOffset();
                }
            } else {
                comparisonIndex = 0;
            }
            i = input.read();
        }
        return -1L;
    }

    public static COSDictionary toDictionary(COSObject object) {
        COSDictionary dict = null;
        if (object instanceof COSDictionary) {
            dict = (COSDictionary)object;
        } else if (object instanceof COSStream) {
            dict = ((COSStream)object).getDict();
        }
        return dict;
    }

    private COSTools() {
    }

    public static class Revision
    implements IRevision {
        private STXRefSection xRefSection;
        private long length;

        @Override
        public ILocator createLocator() {
            ILocator docLocator = this.getXRefSection().getDoc().getLocator();
            LocatorViewport viewLocator = new LocatorViewport(docLocator);
            viewLocator.setName(LocatorTools.getBaseName((ILocator)docLocator) + "_v" + this.getXRefSection().getIncrementalCount() + ".pdf");
            viewLocator.setStart(0L);
            viewLocator.setEnd(this.getLength());
            viewLocator.setReadOnly();
            return viewLocator;
        }

        @Override
        public boolean definesObject(int no) {
            STXRefEntry entry = this.getXRefSection().getEntry(no);
            return entry != null && !entry.isFree();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Revision)) {
                return false;
            }
            return ((Revision)obj).getLength() == this.getLength();
        }

        @Override
        public long getLength() {
            return this.length;
        }

        public STXRefSection getXRefSection() {
            return this.xRefSection;
        }

        public int hashCode() {
            return (int)this.getLength();
        }

        public void setLength(long length) {
            this.length = length;
        }

        public void setXRefSection(STXRefSection refSection) {
            this.xRefSection = refSection;
        }
    }

    public static class LinearizedRevision
    implements IRevision {
        private IRevision firstRevision;
        private IRevision secondRevision;

        public LinearizedRevision(IRevision firstRevision, IRevision secondRevision) {
            this.firstRevision = firstRevision;
            this.secondRevision = secondRevision;
        }

        @Override
        public ILocator createLocator() {
            return this.secondRevision.createLocator();
        }

        @Override
        public boolean definesObject(int no) {
            return this.firstRevision.definesObject(no) || this.secondRevision.definesObject(no);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LinearizedRevision)) {
                return false;
            }
            return ((LinearizedRevision)obj).getLength() == this.getLength();
        }

        @Override
        public long getLength() {
            return this.secondRevision.getLength();
        }

        public int hashCode() {
            return (int)this.getLength();
        }
    }

    public static interface IRevision {
        public ILocator createLocator();

        public boolean definesObject(int var1);

        public long getLength();
    }
}

