/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.table;

import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementSerializationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.string.StringTools;
import de.intarsys.tools.table.ITableRecord;
import de.intarsys.tools.table.TableColumnFunction;
import de.intarsys.tools.table.TableProcessingException;

public class TableColumnLiteralFunction
extends TableColumnFunction {
    private static final String ATTR_LITERAL = "literal";
    private String literal;

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.setLiteral(ElementTools.getString((IElement)element, (String)ATTR_LITERAL, (String)this.getLiteral()));
    }

    @Override
    public String getContent() {
        return this.getLiteral();
    }

    @Override
    public String getLabel() {
        return StringTools.quote((String)this.getLiteral());
    }

    public String getLiteral() {
        return this.literal;
    }

    @Override
    public Object process(ITableRecord item) throws TableProcessingException {
        return this.getLiteral();
    }

    @Override
    public void serialize(IElement element) throws ElementSerializationException {
        super.serialize(element);
        element.setAttributeValue(ATTR_LITERAL, this.getLiteral());
    }

    @Override
    public void setContent(String content) {
        this.setLiteral(content);
    }

    public void setLiteral(String literal) {
        this.literal = literal;
    }
}

