/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.observation.impl;

import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.expression.TemplateEvaluator;
import de.intarsys.tools.observation.impl.CommonPredicate;
import de.intarsys.tools.valueholder.INamedValue;
import java.util.List;
import java.util.regex.Pattern;

public abstract class PatternBasedPredicate
extends CommonPredicate {
    private String expr;
    private String pattern;
    private Pattern compiledPattern;

    protected PatternBasedPredicate() {
    }

    protected PatternBasedPredicate(String name, String pattern) {
        this.expr = name;
        this.setPattern(pattern);
    }

    @Override
    public boolean accept(List<INamedValue> values) {
        Object tempValue = StringEvaluatorTools.evaluate((IStringEvaluator)TemplateEvaluator.get((Mode)Mode.TRUSTED), (Object)this.getExpr());
        if (this.matches(tempValue)) {
            return this.resultValue();
        }
        return !this.resultValue();
    }

    public Pattern getCompiledPattern() {
        return this.compiledPattern;
    }

    public String getExpr() {
        return this.expr;
    }

    public String getPattern() {
        return this.pattern;
    }

    protected boolean matches(Object value) {
        return this.compiledPattern.matcher(String.valueOf(value)).matches();
    }

    protected abstract boolean resultValue();

    public void setCompiledPattern(Pattern compiledPattern) {
        this.compiledPattern = compiledPattern;
    }

    public void setExpr(String name) {
        this.expr = name;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
        this.compiledPattern = Pattern.compile(pattern);
    }
}

