/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.processor.document.standard;

import de.intarsys.document.common.DocumentTools;
import de.intarsys.document.model.DocumentEnvironment;
import de.intarsys.document.model.IDocumentType;
import de.intarsys.processor.common.CommonProcessor;
import de.intarsys.processor.document.standard.PACKAGE;
import de.intarsys.tools.activity.RequestFile;
import de.intarsys.tools.factory.IFactory;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.locator.LocatorUsage;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;

public class LoadSelector
extends CommonProcessor {
    public static final String ARG_DOCUMENT_TYPE_FILTER = "documentTypeFilter";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private ILocator dirLocator;
    private IDocumentType[] documentTypeFilter;
    private ILocator locator;
    private String applicationContext;

    protected LoadSelector(IFactory factory) {
        super(factory);
    }

    protected Object basicGetResult() {
        return this.getLocator();
    }

    @Override
    protected void basicRun() {
        if (this.locator == null) {
            this.locator = this.requestLocator();
        }
        if (this.locator == null) {
            this.cancel();
        } else {
            this.ok();
        }
    }

    @Override
    protected void basicStop() throws Exception {
        if (this.getLocator() != null) {
            LocatorUsage.get().setLastLocator("load", this.getLocator());
            IDocumentType documentType = DocumentTools.getDocumentTypeForExtension((String)LocatorTools.getExtension((ILocator)this.getLocator()));
            if (documentType != null) {
                LocatorUsage.get().setLastLocator("load", documentType.getId(), this.getLocator());
                LocatorUsage.get().setLastLocator("any", documentType.getId(), this.getLocator());
            }
            LocatorUsage.get().setLastLocator("load", this.getApplicationContext(), this.getLocator());
            LocatorUsage.get().setLastLocator("any", this.getApplicationContext(), this.getLocator());
        }
        super.basicStop();
    }

    public String getApplicationContext() {
        return this.applicationContext == null ? LocatorUsage.get().getSharedContext() : this.applicationContext;
    }

    public ILocator getDirLocator() {
        return this.dirLocator;
    }

    public IDocumentType[] getDocumentTypeFilter() {
        return this.documentTypeFilter;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    protected String guiQueryFilenameLoad() {
        String[] names;
        String[] extensions;
        IMessage title = Msg.getMessage("LoadSelector.TitleOpenFile", new Object[0]);
        String filterPath = null;
        if (this.getDirLocator() != null) {
            filterPath = this.getDirLocator().getPath();
        }
        if (this.getDocumentTypeFilter() == null) {
            extensions = DocumentTools.getAllFilterExtensions();
            names = DocumentTools.getAllFilterNames();
        } else {
            extensions = DocumentTools.getFilterExtensionsCompressed((IDocumentType[])this.getDocumentTypeFilter());
            names = DocumentTools.getFilterNamesCompressed((IDocumentType[])this.getDocumentTypeFilter());
        }
        return RequestFile.requestFileLoad((IMessage)title, (String[])extensions, (String[])names, (String)filterPath);
    }

    protected ILocator requestLocator() {
        String filename = this.guiQueryFilenameLoad();
        if (filename != null) {
            try {
                return DocumentEnvironment.get().getLocatorFactory().createLocator(filename);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public void setApplicationContext(String applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setDirLocator(ILocator parent) {
        this.dirLocator = parent;
    }

    public void setDocumentTypeFilter(IDocumentType[] paramDocumentTypeFilter) {
        this.documentTypeFilter = paramDocumentTypeFilter;
    }

    public void setLocator(ILocator paramLocator) {
        this.locator = paramLocator;
    }
}

