/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.xmp.property;

import java.io.IOException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.jempbox.impl.DateConverter;
import org.jempbox.impl.XMLUtil;
import org.jempbox.xmp.IElementable;
import org.jempbox.xmp.XMPSchema;
import org.w3c.dom.Element;

public class PropertyResourceEvent
implements IElementable {
    public static final String RSEVENT_NAMESPACE = "http://ns.adobe.com/xap/1.0/sType/ResourceEvent#";
    public static final String RSVERSION_NAMESPACE = "http://ns.adobe.com/xap/1.0/sType/Version#";
    protected static final String stVerBasePrefix = "stVer";
    protected static final String stEvtBasePrefix = "stEvt";
    public static List<String> stEvtPropertyNames = Arrays.asList("stEvt:action", "stEvt:instanceID", "stEvt:parameters", "stEvt:softwareAgent", "stEvt:when");
    public static List<String> stVerPropertyNames = Arrays.asList("stVer:comments", "stVer:event", "stVer:modifyDate", "stVer:modifier", "stVer:version");
    public static final String ACTION_CONVERTED = "converted";
    public static final String ACTION_COPIED = "copied";
    public static final String ACTION_CREATED = "created";
    public static final String ACTION_CROPPED = "cropped";
    public static final String ACTION_EDITED = "edited";
    public static final String ACTION_FILTERED = "filtered";
    public static final String ACTION_FORMATTED = "formatted";
    public static final String ACTION_VERSION_UPDATED = "version_updated";
    public static final String ACTION_PRINTED = "printed";
    public static final String ACTION_PUBLISHED = "published";
    public static final String ACTION_MANAGED = "managed";
    public static final String ACTION_PRODUCED = "produced";
    public static final String ACTION_RESIZED = "resized";
    protected Element primeParent = null;
    protected Element parent = null;

    public PropertyResourceEvent(Element parentElement) {
        this.primeParent = parentElement;
        if (!this.primeParent.hasAttribute("xmlns:stEvt")) {
            this.primeParent.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:stEvt", RSEVENT_NAMESPACE);
        }
    }

    public PropertyResourceEvent(XMPSchema schema) {
        this.primeParent = schema.getElement().getOwnerDocument().createElement("rdf:li");
        this.primeParent.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:stEvt", RSEVENT_NAMESPACE);
        this.parent = this.primeParent.getOwnerDocument().createElement("rdf:Description");
        this.primeParent.appendChild(this.parent);
    }

    public String getAction() {
        return XMLUtil.getStringValue(this.parent, "stEvt:action");
    }

    @Override
    public Element getElement() {
        return this.primeParent;
    }

    public String getInstanceID() {
        return XMLUtil.getStringValue(this.parent, "stEvt:instanceID");
    }

    public String getManager() {
        return XMLUtil.getStringValue(this.parent, "stRef:manager");
    }

    public String getManagerTo() {
        return XMLUtil.getStringValue(this.parent, "stRef:managerTo");
    }

    public String getManagerUI() {
        return XMLUtil.getStringValue(this.parent, "stRef:managerUI");
    }

    public String getManagerVariant() {
        return XMLUtil.getStringValue(this.parent, "stRef:managerVariant");
    }

    public String getParameters() {
        return XMLUtil.getStringValue(this.parent, "stEvt:parameters");
    }

    public String getSoftwareAgent() {
        return XMLUtil.getStringValue(this.parent, "stEvt:softwareAgent");
    }

    public Calendar getWhen() throws IOException {
        return DateConverter.toCalendar(XMLUtil.getStringValue(this.parent, "stEvt:when"));
    }

    public void setAction(String action) {
        XMLUtil.setStringValue(this.parent, "stEvt:action", action);
    }

    public void setInstanceID(String id) {
        XMLUtil.setStringValue(this.parent, "stEvt:instanceID", id);
    }

    public void setManager(String manager) {
        XMLUtil.setStringValue(this.parent, "stRef:manager", manager);
    }

    public void setManagerTo(String managerTo) {
        XMLUtil.setStringValue(this.parent, "stRef:managerTo", managerTo);
    }

    public void setManagerUI(String managerUI) {
        XMLUtil.setStringValue(this.parent, "stRef:managerUI", managerUI);
    }

    public void setManagerVariant(String managerVariant) {
        XMLUtil.setStringValue(this.parent, "stRef:managerVariant", managerVariant);
    }

    public void setParameters(String param) {
        XMLUtil.setStringValue(this.parent, "stEvt:parameters", param);
    }

    public void setSoftwareAgent(String software) {
        XMLUtil.setStringValue(this.parent, "stEvt:softwareAgent", software);
    }

    public void setWhen(Calendar when) {
        XMLUtil.setStringValue(this.parent, "stEvt:when", DateConverter.toISO8601(when));
    }
}

