/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.xmp.pdfa;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jempbox.impl.XMLUtil;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.pdfa.PropertyPDFAField;
import org.jempbox.xmp.pdfa.PropertyPDFAProperty;
import org.jempbox.xmp.pdfa.PropertyPDFASchema;
import org.jempbox.xmp.pdfa.PropertyPDFAValueType;
import org.jempbox.xmp.pdfa.XMPSchemaPDFAExtension;
import org.jempbox.xmp.pdfa.XMPSchemaPDFAId;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMPMetadataPDFA
extends XMPMetadata {
    protected Map<String, Class<?>> pdfExtensionMappings = new HashMap();

    public static XMPMetadataPDFA load(InputSource is) throws IOException {
        return new XMPMetadataPDFA(XMLUtil.parse(is));
    }

    public static XMPMetadataPDFA load(InputStream is) throws IOException {
        return new XMPMetadataPDFA(XMLUtil.parse(is));
    }

    public XMPMetadataPDFA() throws IOException {
        this.init();
    }

    public XMPMetadataPDFA(Document doc) {
        super(doc);
        this.init();
    }

    public XMPSchemaPDFAId addPDFAIdSchema() {
        XMPSchemaPDFAId schema = new XMPSchemaPDFAId(this);
        return (XMPSchemaPDFAId)this.basicAddSchema(schema);
    }

    public XMPSchemaPDFAExtension addPDFExtensionSchema() {
        XMPSchemaPDFAExtension schema = new XMPSchemaPDFAExtension(this);
        return (XMPSchemaPDFAExtension)this.basicAddSchema(schema);
    }

    public XMPSchemaPDFAExtension getPDFAExtensionSchema() throws IOException {
        return (XMPSchemaPDFAExtension)this.getSchemaByClass(XMPSchemaPDFAExtension.class);
    }

    public XMPSchemaPDFAId getPDFAIdSchema() throws IOException {
        return (XMPSchemaPDFAId)this.getSchemaByClass(XMPSchemaPDFAId.class);
    }

    public boolean hasPDFAExtension() {
        NodeList schemaList = this.xmpDocument.getElementsByTagName("rdf:Description");
        for (int i = 0; i < schemaList.getLength(); ++i) {
            Element schema = (Element)schemaList.item(i);
            NamedNodeMap attributes = schema.getAttributes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node attribute = attributes.item(j);
                String name = attribute.getNodeName();
                String value = attribute.getNodeValue();
                if (!name.startsWith("xmlns:") || !this.pdfExtensionMappings.containsKey(value)) continue;
                return true;
            }
        }
        return false;
    }

    private void init() {
        this.nsMappings.put("http://www.aiim.org/pdfa/ns/id/", XMPSchemaPDFAId.class);
        this.nsMappings.put("http://www.aiim.org/pdfa/ns/extension/", XMPSchemaPDFAExtension.class);
        this.datatypeMappings.put("http://www.aiim.org/pdfa/ns/property#", PropertyPDFAProperty.class);
        this.datatypeMappings.put("http://www.aiim.org/pdfa/ns/schema#", PropertyPDFASchema.class);
        this.datatypeMappings.put("http://www.aiim.org/pdfa/ns/type#", PropertyPDFAValueType.class);
        this.datatypeMappings.put("http://www.aiim.org/pdfa/ns/field#", PropertyPDFAField.class);
        this.pdfExtensionMappings.put("http://www.aiim.org/pdfa/ns/schema#", PropertyPDFASchema.class);
        this.pdfExtensionMappings.put("http://www.aiim.org/pdfa/ns/extension/", XMPSchemaPDFAExtension.class);
    }
}

