/*
 * Decompiled with CFR 0.152.
 */
package org.jempbox.xmp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.jempbox.xmp.Thumbnail;
import org.jempbox.xmp.XMPMetadata;
import org.jempbox.xmp.XMPSchema;
import org.jempbox.xmp.property.XMPSchemaPropertyScheme;
import org.jempbox.xmp.property.XMPSchemaPropertyThumbnail;
import org.w3c.dom.Element;

public class XMPSchemaBasic
extends XMPSchema {
    public static final String NAMESPACE = "http://ns.adobe.com/xap/1.0/";
    protected static final String basePrefix = "xmp";
    protected static final String basePrefixDepr = "xap";
    protected static List<String> propertyNames = Arrays.asList("xmp:Advisory", "xmp:BaseURL", "xmp:CreateDate", "xmp:CreatorTool", "xmp:Identifier", "xmp:Label", "xmp:MetadataDate", "xmp:ModifyDate", "xmp:Nickname", "xmp:Rating", "xmp:Thumbnails", "xap:Advisory", "xap:BaseURL", "xap:CreateDate", "xap:CreatorTool", "xap:Identifier", "xap:Label", "xap:MetadataDate", "xap:ModifyDate", "xap:Nickname", "xap:Rating", "xap:Thumbnails");

    public XMPSchemaBasic(Element element, String prefix) {
        super(element, prefix);
    }

    public XMPSchemaBasic(XMPMetadata parent) {
        super(parent, basePrefix, NAMESPACE);
    }

    public void addAdvisory(String advisory) {
        this.addBagValue(this.prefix + ":Advisory", advisory);
    }

    public void addIdentifier(String id) {
        this.addBagValue(this.prefix + ":Identifier", id);
    }

    public List getAdvisories() {
        return this.getBagList(this.prefix + ":Advisory");
    }

    public String getBaseURL() {
        return this.getTextProperty(this.prefix + ":BaseURL");
    }

    public Calendar getCreateDate() throws IOException {
        return this.getDateProperty(this.prefix + ":CreateDate");
    }

    public String getCreatorTool() {
        return this.getTextProperty(this.prefix + ":CreatorTool");
    }

    public List getIdentifiers() {
        return this.getBagList(this.prefix + ":Identifier");
    }

    public String getLabel() {
        return this.getTextProperty(this.prefix + ":Label");
    }

    public Calendar getMetadataDate() throws IOException {
        return this.getDateProperty(this.prefix + ":MetadataDate");
    }

    public Calendar getModifyDate() throws IOException {
        return this.getDateProperty(this.prefix + ":ModifyDate");
    }

    public String getNickname() {
        return this.getTextProperty(this.prefix + ":Nickname");
    }

    @Override
    protected List<String> getPropertyNames() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(propertyNames);
        result.addAll(XMPSchemaPropertyThumbnail.propertyNames);
        result.addAll(XMPSchemaPropertyScheme.propertyNames);
        return result;
    }

    public Integer getRating() {
        return this.getIntegerProperty(this.prefix + ":Rating");
    }

    public Thumbnail getThumbnail() {
        return this.getThumbnailProperty(this.prefix + ":Thumbnails", null);
    }

    public Thumbnail getThumbnail(String language) {
        return this.getThumbnailProperty(this.prefix + ":Thumbnails", language);
    }

    public List getThumbnailLanguages() {
        return this.getLanguagePropertyLanguages(this.prefix + ":Thumbnails");
    }

    public String getTitle() {
        return this.getTextProperty(this.prefix + ":Title");
    }

    public void removeAdvisory(String advisory) {
        this.removeBagValue(this.prefix + ":Advisory", advisory);
    }

    public void removeIdentifier(String id) {
        this.removeBagValue(this.prefix + ":Identifier", id);
    }

    public void setBaseURL(String url) {
        this.setTextProperty(this.prefix + ":BaseURL", url);
    }

    public void setCreateDate(Calendar date) {
        this.setDateProperty(this.prefix + ":CreateDate", date);
    }

    public void setCreatorTool(String creator) {
        this.setTextProperty(this.prefix + ":CreatorTool", creator);
    }

    public void setLabel(String label) {
        this.setTextProperty(this.prefix + ":Label", label);
    }

    public void setMetadataDate(Calendar date) {
        this.setDateProperty(this.prefix + ":MetadataDate", date);
    }

    public void setModifyDate(Calendar date) {
        this.setDateProperty(this.prefix + ":ModifyDate", date);
    }

    public void setNickname(String nickname) {
        this.setTextProperty(this.prefix + ":Nickname", nickname);
    }

    public void setRating(Integer rating) {
        this.setIntegerProperty(this.prefix + ":Rating", rating);
    }

    public void setThumbnail(String language, Thumbnail thumbnail) {
        this.setThumbnailProperty(this.prefix + ":Thumbnails", language, thumbnail);
    }

    public void setThumbnail(Thumbnail thumbnail) {
        this.setThumbnailProperty(this.prefix + ":Thumbnails", null, thumbnail);
    }

    public void setTitle(String title) {
        this.setTextProperty(this.prefix + ":Title", title);
    }
}

