/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.client;

import de.intarsys.tools.http.common.HttpTools;
import de.intarsys.tools.http.httpcomponents.LocatorBody;
import de.intarsys.tools.http.httpcomponents.StandardHttpClientBuilder;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorTools;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

public class HttpAgent {
    public static ILocator get(String url) throws IOException {
        CloseableHttpResponse response;
        block3: {
            ByteArrayLocator byteArrayLocator;
            HttpGet method = new HttpGet(url);
            CloseableHttpClient client = new StandardHttpClientBuilder().build();
            response = null;
            HttpEntity entity = null;
            try {
                response = client.execute((HttpUriRequest)method);
                entity = response.getEntity();
                if (response.getStatusLine().getStatusCode() != 200) break block3;
                String charset = HttpTools.getHeaderElementParam((Header)entity.getContentType(), (String)"charset", (String)StandardCharsets.ISO_8859_1.name());
                String filename = HttpTools.getContentDispositionParamFilename((Header[])response.getAllHeaders(), (String)"temp.file");
                byte[] bytes = EntityUtils.toByteArray((HttpEntity)entity);
                ByteArrayLocator locator = new ByteArrayLocator(bytes, filename);
                locator.setCharset(charset);
                byteArrayLocator = locator;
            }
            catch (Throwable throwable) {
                EntityUtils.consume(entity);
                client.close();
                throw throwable;
            }
            EntityUtils.consume((HttpEntity)entity);
            client.close();
            return byteArrayLocator;
        }
        throw new IOException("HTTP POST failed with: " + response.getStatusLine());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void post(String url, ILocator content) throws IOException {
        HttpPost method = new HttpPost(url);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.addPart(LocatorTools.getBaseName((ILocator)content), (ContentBody)new LocatorBody(content));
        method.setEntity(builder.build());
        CloseableHttpClient client = new StandardHttpClientBuilder().build();
        CloseableHttpResponse response = null;
        HttpEntity entity = null;
        try {
            response = client.execute((HttpUriRequest)method);
            entity = response.getEntity();
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("HTTP POST failed with: " + response.getStatusLine());
            }
        }
        catch (Throwable throwable) {
            EntityUtils.consume(entity);
            client.close();
            throw throwable;
        }
        EntityUtils.consume((HttpEntity)entity);
        client.close();
    }

    private HttpAgent() {
    }
}

