/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.validation;

import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.security.app.signature.CommonValidationDataExtender;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.method.pdf.common.PDExtensionTools;
import de.intarsys.security.method.pdf.signature.PDFDocumentSecurityStore;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainerEntry;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.exception.ExceptionTools;
import java.io.IOException;

public class PDFValidationDataExtender
extends CommonValidationDataExtender<PDFSignatureContainerEntry> {
    protected void extend(PDFSignatureContainerEntry entry, IExtendedValidationData validationData) throws IOException {
        PDDocument pdDoc = entry.getPDSignature().getDoc();
        PDFDocumentSecurityStore dss = PDFDocumentSecurityStore.get(pdDoc);
        try {
            validationData.getCRLs().forEach(crl -> {
                try {
                    dss.addCRL((IX509CRL)crl);
                }
                catch (IOException e) {
                    throw ExceptionTools.wrapTyped((Throwable)e, IOException.class);
                }
            });
            validationData.getOCSPResponses().forEach(ocsp -> {
                try {
                    dss.addOCSPResponse((IOCSPResponse)ocsp);
                }
                catch (IOException e) {
                    throw ExceptionTools.wrapTyped((Throwable)e, IOException.class);
                }
            });
            validationData.getCertificates().forEach(certificate -> {
                try {
                    dss.addCertificate((IX509PublicKeyCertificate)certificate);
                }
                catch (IOException e) {
                    throw ExceptionTools.wrapTyped((Throwable)e, IOException.class);
                }
            });
        }
        catch (Exception e) {
            throw (IOException)ExceptionTools.unwrapTypedFromChain((Throwable)e, IOException.class);
        }
        if (dss.isChanged()) {
            PDExtensionTools.updateDeveloperExtensions(pdDoc, "1.7", 5);
        }
    }
}

