/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.validation;

import de.intarsys.security.app.validation.CommonSignatureContainerValidator;
import de.intarsys.security.app.validation.ISignatureContainerEntryValidator;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.app.validation.common.ValidationContext;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainer;
import de.intarsys.security.method.pdf.signature.PDFSignatureContainerEntry;
import de.intarsys.security.method.pdf.validation.PDFSignatureContainerEntryValidator;
import de.intarsys.security.signature.ISignatureContainer;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.standard.validation.CommonValidationMessages;
import de.intarsys.security.standard.validation.VSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainer;
import de.intarsys.security.validation.IVSSignatureContainerEntry;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.Closeable;
import java.io.IOException;

public class PDFSignatureContainerValidator
extends CommonSignatureContainerValidator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IVSSignatureContainer validate(ISignatureContainer signatureContainer, IDigest digest, IValidationParameters parameters) {
        PDFSignatureContainer pdfSignatureContainer = (PDFSignatureContainer)signatureContainer;
        VSSignatureContainer containerState = new VSSignatureContainer((ISignatureContainer)pdfSignatureContainer);
        IRandomAccess randomAccess = null;
        try {
            randomAccess = pdfSignatureContainer.getLocator().getRandomAccess();
            randomAccess.seek(0L);
            randomAccess.mark();
            for (PDFSignatureContainerEntry entry : pdfSignatureContainer.getEntries()) {
                if (Thread.currentThread().isInterrupted()) {
                    break;
                }
                ValidationParameters localParams = ValidationParameters.copy((IValidationParameters)parameters);
                localParams.setAttribute((Object)PDFSignatureContainerEntryValidator.ATTR_RANDOMACCESS, (Object)randomAccess);
                ISignatureContainerEntryValidator entryValidator = ValidationContext.get().getSignatureContainerEntryValidator();
                IVSSignatureContainerEntry entryState = entryValidator.validate((ISignatureContainerEntry)entry, digest, (IValidationParameters)localParams);
                containerState.addEntryState(entryState);
                randomAccess.reset();
            }
        }
        catch (IOException e) {
            containerState.invalidate(CommonValidationMessages.ERROR_IO((Exception)e));
        }
        finally {
            StreamTools.close((Closeable)randomAccess);
        }
        return containerState;
    }
}

