/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.pdf.signature;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDSignature;
import de.intarsys.pdf.pd.PDSignatureLock;
import de.intarsys.pdf.pd.PDSignatureReference;
import de.intarsys.pdf.pd.PDTransformMethod;
import de.intarsys.pdf.pd.PDTransformMethodDocMDP;
import de.intarsys.pdf.pd.PDTransformParams;
import de.intarsys.security.app.PermissionDenied;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.method.pdf.common.PDFAdditionalInfoDefinition;
import de.intarsys.security.method.pdf.signature.CommonPDDocumentSigner;
import de.intarsys.security.method.pdf.signature.IPDDocumentSignatureEncoder;
import de.intarsys.security.method.pdf.signature.PDDocumentSignerParameters;
import de.intarsys.security.signature.additionalinfo.IAdditionalInfo;
import de.intarsys.security.signature.additionalinfo.IAdditionalInfoSet;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class PDDocumentSigner
extends CommonPDDocumentSigner {
    protected static final Logger Log = LoggerFactory.getLogger(PDDocumentSigner.class);
    private IAdditionalInfoSet additionalInfoSet;
    private boolean allowDeferredCertification;

    protected static boolean isCertified(PDDocument doc) {
        COSObject cosDocMDPSig;
        COSDictionary perms = doc.cosGetPermissionsDict();
        if (perms != null && !(cosDocMDPSig = perms.get(PDTransformMethod.DK_DocMDP)).isNull()) {
            PDSignature sig = (PDSignature)PDSignature.META.createFromCos(cosDocMDPSig);
            List references = sig.getSignatureReferences();
            for (PDSignatureReference reference : references) {
                if (reference.getTransformMethod() != PDTransformMethodDocMDP.SINGLETON) continue;
                return true;
            }
        }
        return false;
    }

    public PDDocumentSigner(IPDDocumentSignatureEncoder encoder) {
        super(encoder);
    }

    protected void addAdditionalInfo(PDSignature pdSignature) {
        if (this.getAdditionalInfoSet() == null) {
            return;
        }
        if (Log.isEnabledForLevel(Level.TRACE)) {
            Log.trace("adding addition info fields");
        }
        PDFAdditionalInfoDefinition definition = (PDFAdditionalInfoDefinition)this.getAdditionalInfoSet().getDefinition();
        String value = this.getAdditionalInfoSet().getValue((IAdditionalInfo)definition.name);
        if (!StringTools.isEmpty((String)value)) {
            pdSignature.setName(value);
        }
        if (!StringTools.isEmpty((String)(value = this.getAdditionalInfoSet().getValue((IAdditionalInfo)definition.reason)))) {
            pdSignature.setReason(value);
        }
        if (!StringTools.isEmpty((String)(value = this.getAdditionalInfoSet().getValue((IAdditionalInfo)definition.contactInfo)))) {
            pdSignature.setContactInfo(value);
        }
        if (!StringTools.isEmpty((String)(value = this.getAdditionalInfoSet().getValue((IAdditionalInfo)definition.location)))) {
            pdSignature.setLocation(value);
        }
    }

    @Override
    protected PDSignature basicCreatePDSignature() {
        return (PDSignature)PDSignature.META.createNew();
    }

    @Override
    protected void checkPermissions(PDDocument document) throws SecurityApplicationException {
        super.checkPermissions(document);
        if (!document.getAccessPermissions().mayFillForm()) {
            throw new PermissionDenied("Form filling is forbidden for this document.");
        }
    }

    protected void createDocMDP(PDAFSignatureField field, PDSignature signature, PDDocument document, PDDocumentSignerParameters parameters) {
        ArrayList<PDSignatureReference> references = signature.getSignatureReferences();
        if (references == null) {
            references = new ArrayList<PDSignatureReference>();
        }
        PDSignatureReference reference = (PDSignatureReference)PDSignatureReference.META.createNew();
        PDTransformMethod method = (PDTransformMethod)PDTransformMethod.META.createFromCos((COSObject)PDTransformMethod.DK_DocMDP);
        PDTransformParams params = (PDTransformParams)PDTransformParams.META.createNew();
        params.setPermissions(parameters.getPermissions().getValue());
        reference.setTransformMethod(method);
        reference.setTransformParams(params);
        reference.cosSetData(document.getCatalog().cosGetObject());
        references.add(reference);
        signature.setSignatureReferences(references);
        document.setPermissions(PDTransformMethod.DK_DocMDP, signature);
    }

    public IAdditionalInfoSet getAdditionalInfoSet() {
        return this.additionalInfoSet;
    }

    protected void handleFieldLock(PDAFSignatureField field, PDSignature signature, PDDocument doc, PDDocumentSignerParameters parameters, boolean includeField) {
        PDSignatureLock lock = parameters.getLock();
        if (lock == null) {
            lock = field.getLock();
        }
        if (includeField) {
            if (lock == null) {
                lock = (PDSignatureLock)PDSignatureLock.META.createNew();
                lock.cosSetAction(PDSignatureLock.CN_Include);
                lock.cosSetFields(COSArray.create());
            }
            if (!lock.isActionAll()) {
                ArrayList<String> fields = lock.getFields();
                if (lock.isActionInclude()) {
                    fieldName = field.getQualifiedName();
                    if (fields == null) {
                        fields = new ArrayList<String>();
                    }
                    if (!fields.contains(fieldName)) {
                        fields.add(fieldName);
                    }
                } else if (lock.isActionExclude() && fields != null) {
                    fieldName = field.getQualifiedName();
                    fields.remove(fieldName);
                }
                lock.setFields((List)fields);
            }
        } else if (lock == null) {
            return;
        }
        ArrayList<PDSignatureReference> references = signature.getSignatureReferences();
        if (references == null) {
            references = new ArrayList<PDSignatureReference>();
        }
        PDSignatureReference reference = (PDSignatureReference)PDSignatureReference.META.createNew();
        PDTransformMethod method = (PDTransformMethod)PDTransformMethod.META.createFromCos((COSObject)PDTransformMethod.DK_FieldMDP);
        PDTransformParams params = (PDTransformParams)PDTransformParams.META.createNew();
        params.cosSetAction((COSName)lock.cosGetAction().copyShallow());
        if (lock.cosGetFields() != null) {
            params.cosSetFields((COSArray)lock.cosGetFields().copyShallow());
        }
        reference.setTransformMethod(method);
        reference.setTransformParams(params);
        references.add(reference);
        signature.setSignatureReferences(references);
        List lockedFieldNames = lock.getFields();
        PDAcroForm form = field.getAcroForm();
        for (PDAcroFormField currentField : form.collectLeafFields()) {
            if (lock.isActionAll()) {
                this.lockField(currentField);
                continue;
            }
            if (lock.isActionInclude()) {
                if (!lockedFieldNames.contains(currentField.getQualifiedName())) continue;
                this.lockField(currentField);
                continue;
            }
            if (!lock.isActionExclude() || lockedFieldNames.contains(currentField.getQualifiedName())) continue;
            this.lockField(currentField);
        }
    }

    public boolean isAllowDeferredCertification() {
        return this.allowDeferredCertification;
    }

    protected void lockField(PDAcroFormField field) {
        for (PDAnnotation annotation : field.getAnnotations()) {
            annotation.setLocked(true);
        }
    }

    @Override
    protected void preparePDSignature(PDSignature pdSignature, PDAFSignatureField field, PDDocument document, PDDocumentSignerParameters parameters) {
        PDAcroForm form = document.getAcroForm();
        boolean certify = parameters.isCreateCertificationSignature();
        if (certify && form.isSigned()) {
            if (this.isAllowDeferredCertification()) {
                if (PDDocumentSigner.isCertified(document)) {
                    certify = false;
                }
            } else {
                certify = false;
            }
        }
        if (certify) {
            this.handleFieldLock(field, pdSignature, document, parameters, true);
            this.createDocMDP(field, pdSignature, document, parameters);
        } else {
            this.handleFieldLock(field, pdSignature, document, parameters, false);
        }
        this.addAdditionalInfo(pdSignature);
    }

    public void setAdditionalInfoSet(IAdditionalInfoSet additionalInfoSet) {
        this.additionalInfoSet = additionalInfoSet;
    }

    public void setAllowDeferredCertification(boolean allowDeferredCertification) {
        this.allowDeferredCertification = allowDeferredCertification;
    }
}

