/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.history;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.COSTools;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.signature.change.GeneralRevisionChange;
import de.intarsys.pdf.signature.history.ChangeIdentifierContext;
import de.intarsys.pdf.signature.history.IChangeIdentifierContext;
import de.intarsys.pdf.st.STTools;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.tools.locator.ILocator;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HistoryTools {
    protected static List<IDocumentChange> calculateChanges(COSDocument baseDocument, COSDocument newDocument) throws IOException, COSLoadException {
        Map baseEntries = STTools.getOccupiedEntries((STXRefSection)baseDocument.stGetDoc().getXRefSection());
        Map entries = STTools.getOccupiedEntriesExclusive((STXRefSection)newDocument.stGetDoc().getXRefSection());
        ChangeIdentifierContext context = new ChangeIdentifierContext();
        context.setBaseDocument(baseDocument);
        context.setNewDocument(newDocument);
        COSIndirectObject baseCatalogObj = baseDocument.getCatalog().cosGetObject().getIndirectObject();
        COSIndirectObject newCatalogObj = newDocument.getCatalog().cosGetObject().getIndirectObject();
        if (!baseCatalogObj.getKey().equals((Object)newCatalogObj.getKey())) {
            context.addChangedObject(baseCatalogObj, newCatalogObj);
        }
        for (COSObjectKey key : entries.keySet()) {
            COSIndirectObject baseObject;
            if (!baseEntries.containsKey(key) || !(baseObject = baseDocument.stGetDoc().getObjectReference(key.getObjectNumber(), key.getGenerationNumber())).exists()) continue;
            COSIndirectObject newObject = newDocument.stGetDoc().getObjectReference(key.getObjectNumber(), key.getGenerationNumber());
            context.addChangedObject(baseObject, newObject);
        }
        return context.process();
    }

    protected static List<IDocumentChange> calculateChanges(COSDocument doc, COSTools.IRevision base, List<COSTools.IRevision> subsequentRevisions) throws IOException, COSLoadException {
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        COSDocument baseDocument = null;
        COSDocument newDocument = null;
        for (COSTools.IRevision revision : subsequentRevisions) {
            HashMap<String, ISystemSecurityHandler> options = new HashMap<String, ISystemSecurityHandler>();
            options.put("systemSecurityHandler", doc.stGetDoc().getReadSecurityHandler());
            baseDocument = baseDocument == null ? COSDocument.createFromLocator((ILocator)base.createLocator(), options) : newDocument;
            newDocument = COSDocument.createFromLocator((ILocator)revision.createLocator(), options);
            changes.addAll(HistoryTools.calculateChanges(baseDocument, newDocument));
            baseDocument.close();
        }
        newDocument.close();
        return changes;
    }

    public static Set<ObjectKey> collectObjectKeys(COSArray annots) throws IOException, COSLoadException {
        HashSet<ObjectKey> keys = new HashSet<ObjectKey>();
        for (int i = 0; i < annots.size(); ++i) {
            COSIndirectObject ref = annots.get(i).getIndirectObject();
            ObjectKey key = new ObjectKey(i);
            if (ref != null) {
                key.setCosKey(ref.getKey());
            }
            keys.add(key);
        }
        return keys;
    }

    public static Set<ObjectKey> collectObjectKeys(COSArray baseAnnots, COSArray newAnnots) throws IOException, COSLoadException {
        HashSet<ObjectKey> allKeys = new HashSet<ObjectKey>();
        allKeys.addAll(HistoryTools.collectObjectKeys(baseAnnots));
        allKeys.addAll(HistoryTools.collectObjectKeys(newAnnots));
        return allKeys;
    }

    public static void compareDictionary(COSDictionary dict1, COSDictionary dict2, IEntryComparator comparator) throws IOException, COSLoadException {
        dict1 = dict1 == null ? COSDictionary.create() : dict1;
        dict2 = dict2 == null ? COSDictionary.create() : dict2;
        HashSet keys = new HashSet();
        keys.addAll(dict1.keySet());
        keys.addAll(dict2.keySet());
        for (COSName key : keys) {
            COSObject value1 = dict1.get(key);
            COSObject value2 = dict2.get(key);
            comparator.compare(key, value1, value2);
        }
    }

    public static boolean equals(COSIndirectObject obj1, COSIndirectObject obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        return HistoryTools.secureEquals(obj1, obj2);
    }

    public static boolean equals(COSObject obj1, COSObject obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        if (obj2 == null) {
            return false;
        }
        if (obj1.isIndirect() && obj2.isIndirect() && HistoryTools.secureEquals(obj1.getIndirectObject(), obj2.getIndirectObject())) {
            return true;
        }
        return HistoryTools.secureEquals(obj1, obj2);
    }

    public static List<IDocumentChange> generateHistory(COSDocument doc, COSTools.IRevision base) throws IOException, COSLoadException {
        List subsequentRevisions = COSTools.getSubsequentRevisions((COSDocument)doc, (COSTools.IRevision)base);
        if (subsequentRevisions.isEmpty()) {
            return Collections.emptyList();
        }
        List<IDocumentChange> changes = HistoryTools.calculateChanges(doc, base, subsequentRevisions);
        if (changes.isEmpty()) {
            changes.add(new GeneralRevisionChange());
        }
        return changes;
    }

    public static boolean isEntry(COSDictionary dict, COSIndirectObject baseObject) {
        Set keySet = dict.keySet();
        COSName[] keys = new COSName[keySet.size()];
        dict.keySet().toArray(keys);
        return HistoryTools.isEntry(dict, keys, baseObject);
    }

    public static boolean isEntry(COSDictionary dict, COSName key, COSIndirectObject baseObject) {
        COSObject value = dict.get(key);
        COSIndirectObject obj = value.getIndirectObject();
        return obj == baseObject;
    }

    public static boolean isEntry(COSDictionary dict, COSName[] keys, COSIndirectObject baseObject) {
        for (COSName key : keys) {
            if (!HistoryTools.isEntry(dict, key, baseObject)) continue;
            return true;
        }
        return false;
    }

    public static Map<ObjectKey, COSObject> mapObjects(COSArray array) throws IOException, COSLoadException {
        ObjectMap objects = new ObjectMap(array);
        return objects;
    }

    protected static boolean secureEquals(COSArray obj1, COSArray obj2) {
        if (obj1.size() > obj2.size()) {
            return false;
        }
        if (obj1.size() < obj2.size()) {
            return false;
        }
        Iterator iThis = obj1.basicIterator();
        Iterator iOther = obj2.basicIterator();
        while (iThis.hasNext() && iOther.hasNext()) {
            COSDocumentElement eOther;
            COSObject oOther;
            COSDocumentElement eThis = (COSDocumentElement)iThis.next();
            COSObject oThis = eThis.dereference();
            if (HistoryTools.equals(oThis, oOther = (eOther = (COSDocumentElement)iOther.next()).dereference())) continue;
            return false;
        }
        return !iThis.hasNext() && !iOther.hasNext();
    }

    protected static boolean secureEquals(COSDictionary obj1, COSDictionary obj2) {
        if (obj1.size() > obj2.size()) {
            return false;
        }
        if (obj1.size() < obj2.size()) {
            return false;
        }
        HashSet keys = new HashSet();
        keys.addAll(obj1.keySet());
        keys.addAll(obj2.keySet());
        for (COSName key : keys) {
            COSObject eOther;
            COSObject oOther;
            COSObject eThis = obj1.get(key);
            COSObject oThis = eThis.dereference();
            if (HistoryTools.equals(oThis, oOther = (eOther = obj2.get(key)).dereference())) continue;
            return false;
        }
        return true;
    }

    protected static boolean secureEquals(COSIndirectObject obj1, COSIndirectObject obj2) {
        COSObjectKey key1 = obj1.getKey();
        COSObjectKey key2 = obj2.getKey();
        if (key1.getObjectNumber() != key2.getObjectNumber()) {
            return false;
        }
        return key1.getGenerationNumber() == key2.getGenerationNumber();
    }

    protected static boolean secureEquals(COSNumber obj1, COSNumber obj2) {
        return obj1.floatValue() == obj2.floatValue();
    }

    protected static boolean secureEquals(COSObject obj1, COSObject obj2) {
        if (obj1 instanceof COSDictionary && obj2 instanceof COSDictionary) {
            return HistoryTools.secureEquals((COSDictionary)obj1, (COSDictionary)obj2);
        }
        if (obj1 instanceof COSArray && obj2 instanceof COSArray) {
            return HistoryTools.secureEquals((COSArray)obj1, (COSArray)obj2);
        }
        if (obj1 instanceof COSStream && obj2 instanceof COSStream) {
            return HistoryTools.secureEquals((COSStream)obj1, (COSStream)obj2);
        }
        if (obj1 instanceof COSNumber && obj2 instanceof COSNumber) {
            return HistoryTools.secureEquals((COSNumber)obj1, (COSNumber)obj2);
        }
        if (obj1 instanceof COSString && obj2 instanceof COSString) {
            return HistoryTools.secureEquals((COSString)obj1, (COSString)obj2);
        }
        return obj1.equals(obj2);
    }

    protected static boolean secureEquals(COSStream obj1, COSStream obj2) {
        if (obj1.getLength() != obj2.getLength()) {
            return false;
        }
        if (!Arrays.equals(obj1.getEncodedBytes(), obj2.getEncodedBytes())) {
            return false;
        }
        return HistoryTools.equals((COSObject)obj1.getDict(), (COSObject)obj2.getDict());
    }

    protected static boolean secureEquals(COSString obj1, COSString obj2) {
        if (obj1.equals((Object)obj2)) {
            return true;
        }
        return obj1.stringValue().equals(obj2.stringValue());
    }

    public static void setProcessed(IChangeIdentifierContext context, COSObject baseObj, COSObject newObj) {
        if (baseObj.isIndirect()) {
            context.setProcessed(baseObj.getIndirectObject());
        }
        if (newObj.isIndirect()) {
            context.setProcessed(newObj.getIndirectObject());
        }
    }

    public static boolean skipCompare(COSObject obj1, COSObject obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj2 != null && obj1.isIndirect() && obj2.isIndirect() && HistoryTools.equals(obj1.getIndirectObject(), obj2.getIndirectObject());
    }

    public static class ObjectKey {
        private COSObjectKey cosKey;
        private int index;

        public ObjectKey(COSObjectKey cosKey, int index) {
            this.cosKey = cosKey;
            this.index = index;
        }

        public ObjectKey(int index) {
            this.index = index;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ObjectKey)) {
                return false;
            }
            ObjectKey other = (ObjectKey)obj;
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            if (this.getCosKey() == null) {
                return other.getCosKey() == null;
            }
            return this.getCosKey().equals((Object)other.getCosKey());
        }

        public COSObjectKey getCosKey() {
            return this.cosKey;
        }

        public int getIndex() {
            return this.index;
        }

        public int hashCode() {
            return this.getIndex();
        }

        public void setCosKey(COSObjectKey cosKey) {
            this.cosKey = cosKey;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    public static interface IEntryComparator {
        public void compare(COSName var1, COSObject var2, COSObject var3) throws IOException, COSLoadException;
    }

    public static class ObjectMap
    extends AbstractMap<ObjectKey, COSObject> {
        private Map<COSObjectKey, COSObject> byKey = new HashMap<COSObjectKey, COSObject>();
        private COSArray byIndex;

        public ObjectMap(COSArray array) {
            this.byIndex = array;
            for (int i = 0; i < array.size(); ++i) {
                COSObject object = array.get(i);
                COSIndirectObject ref = object.getIndirectObject();
                if (ref == null) continue;
                this.byKey.put(ref.getKey(), object);
            }
        }

        @Override
        public Set<Map.Entry<ObjectKey, COSObject>> entrySet() {
            HashSet<Map.Entry<ObjectKey, COSObject>> entries = new HashSet<Map.Entry<ObjectKey, COSObject>>();
            for (int i = 0; i < this.byIndex.size(); ++i) {
                COSObject object = this.byIndex.get(i);
                COSIndirectObject ref = object.getIndirectObject();
                ObjectKey key = new ObjectKey(i);
                if (ref != null) {
                    key.setCosKey(ref.getKey());
                }
                entries.add(new AbstractMap.SimpleImmutableEntry<ObjectKey, COSObject>(key, object));
            }
            return entries;
        }

        @Override
        public COSObject get(Object key) {
            COSObject object;
            ObjectKey objectKey = (ObjectKey)key;
            if (objectKey.getCosKey() != null && (object = this.byKey.get(objectKey.getCosKey())) != null) {
                return object;
            }
            if (this.byIndex.size() > objectKey.getIndex() && (object = this.byIndex.get(objectKey.getIndex())) != null) {
                return object;
            }
            return null;
        }
    }
}

