/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.signature.history;

import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.signature.change.DefaultChange;
import de.intarsys.pdf.signature.change.IgnorableChange;
import de.intarsys.pdf.signature.history.DSSChangeIdentifier;
import de.intarsys.pdf.signature.history.FormChangeIdentifier;
import de.intarsys.pdf.signature.history.HistoryTools;
import de.intarsys.pdf.signature.history.IChangeIdentifier;
import de.intarsys.pdf.signature.history.IChangeIdentifierContext;
import de.intarsys.pdf.signature.history.PACKAGE;
import de.intarsys.security.validation.IDocumentChange;
import de.intarsys.tools.message.IMessageBundle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CatalogChangeIdentifier
implements IChangeIdentifier {
    private static final IMessageBundle Msg = PACKAGE.Messages;

    protected List<IDocumentChange> compareCatalog(final COSIndirectObject baseObject, COSIndirectObject newObject, final IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        final ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        COSDictionary baseDict = baseObject.dereference().asDictionary();
        COSDictionary newDict = newObject.dereference().asDictionary();
        if (baseDict == null) {
            if (newDict != null) {
                changes.add(new DefaultChange(Msg.getString("CatalogChangeIdentifier.MessageCatalogChanged", new Object[]{baseObject.getKey()})));
            }
        } else if (newDict == null) {
            changes.add(new DefaultChange(Msg.getString("CatalogChangeIdentifier.MessageCatalogChanged", new Object[]{baseObject.getKey()})));
        } else {
            HistoryTools.compareDictionary(baseDict, newDict, new HistoryTools.IEntryComparator(){

                @Override
                public void compare(COSName key, COSObject baseEntry, COSObject newEntry) throws IOException, COSLoadException {
                    if (HistoryTools.skipCompare(baseEntry, newEntry)) {
                        return;
                    }
                    if (!HistoryTools.equals(baseEntry, newEntry)) {
                        if (COSCatalog.DK_Metadata.equals((Object)key)) {
                            changes.add(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageMetadataChanged", new Object[]{baseObject.getKey()})));
                        } else if (COSCatalog.DK_DSS.equals((Object)key)) {
                            changes.addAll(new DSSChangeIdentifier().basicCompareDSS(baseObject, baseEntry.asDictionary(), newEntry.asDictionary(), context));
                        } else if (COSCatalog.DK_Extensions.equals((Object)key)) {
                            changes.add(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageExtensionsChanged", new Object[]{baseObject.getKey()})));
                        } else if (COSCatalog.DK_Version.equals((Object)key)) {
                            changes.add(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageVersionChanged", new Object[]{baseObject.getKey()})));
                        } else if (COSCatalog.DK_AcroForm.equals((Object)key)) {
                            changes.addAll(new FormChangeIdentifier().basicCompareAcroForm(baseObject, baseEntry.asDictionary(), newEntry.asDictionary(), context));
                        } else if (COSCatalog.DK_StructTreeRoot.equals((Object)key)) {
                            changes.add(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageStructTreeRootChanged", new Object[]{baseObject.getKey()})));
                        } else if (COSCatalog.DK_Lang.equals((Object)key)) {
                            changes.add(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageLangChanged", new Object[]{baseObject.getKey()})));
                        } else {
                            changes.add(new DefaultChange(Msg.getString("CatalogChangeIdentifier.MessageCatalogChanged", new Object[]{baseObject.getKey()})));
                        }
                    }
                    HistoryTools.setProcessed(context, baseEntry, newEntry);
                }
            });
        }
        return changes;
    }

    protected List<IDocumentChange> compareDSS(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        changes.add(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageDSSChanged", new Object[]{baseObject.getKey()})));
        return changes;
    }

    protected List<IDocumentChange> compareMetadata(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        if (context.isProcessed(baseObject)) {
            return Collections.emptyList();
        }
        context.setProcessed(baseObject);
        ArrayList<IDocumentChange> changes = new ArrayList<IDocumentChange>();
        changes.add(new IgnorableChange(Msg.getString("CatalogChangeIdentifier.MessageMetadataChanged", new Object[]{baseObject.getKey()})));
        return changes;
    }

    @Override
    public List<IDocumentChange> identifyChange(COSIndirectObject baseObject, COSIndirectObject newObject, IChangeIdentifierContext context) throws IOException, COSLoadException {
        COSDocument baseDocument = context.getBaseDocument();
        COSCatalog catalog = baseDocument.getCatalog();
        if (catalog != null) {
            COSIndirectObject catalogRef = catalog.cosGetObject().getIndirectObject();
            if (catalogRef == baseObject) {
                return this.compareCatalog(baseObject, newObject, context);
            }
            COSIndirectObject metadataRef = catalog.cosGetDict().get(COSCatalog.DK_Metadata).getIndirectObject();
            if (metadataRef == baseObject) {
                return this.compareMetadata(baseObject, newObject, context);
            }
        }
        return Collections.emptyList();
    }
}

