/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.claptz.io;

import de.intarsys.claptz.IInstrument;
import de.intarsys.claptz.InstrumentRegistryException;
import de.intarsys.claptz.impl.StandardInstrument;
import de.intarsys.claptz.impl.StandardInstrumentRegistry;
import de.intarsys.claptz.io.CommonInstrumentStore;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.expression.ExpressionEvaluator;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.IStringEvaluatorAccess;
import de.intarsys.tools.expression.Mode;
import de.intarsys.tools.expression.ScopedResolver;
import de.intarsys.tools.file.IPathFilter;
import de.intarsys.tools.infoset.ElementFactory;
import de.intarsys.tools.infoset.IDocument;
import de.intarsys.tools.locator.ClassLoaderResourceLocatorFactory;
import de.intarsys.tools.locator.ILocatorFactory;
import de.intarsys.tools.locator.RelativeLocatorFactory;
import de.intarsys.tools.monitor.ITrace;
import de.intarsys.tools.monitor.TimeMonitor;
import de.intarsys.tools.reflect.ClassTools;
import de.intarsys.tools.xfs.IXFSNode;
import de.intarsys.tools.xfs.XFSScanner;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XFSInstrumentStore
extends CommonInstrumentStore {
    public static final String DEFAULT_PATTERN = ".*/INSTRUMENT-INF/instrument.xml";
    public static final String DEFAULT_SCAN_SPEC = "instruments";
    private static final Logger Log = LoggerFactory.getLogger(XFSInstrumentStore.class);
    private static final TimeMonitor MONITOR = new TimeMonitor(ClassTools.getUnqualifiedName(XFSInstrumentStore.class));
    private final ClassLoader classLoader;
    private String pattern;
    private String rootPath;

    public XFSInstrumentStore(ClassLoader classLoader) {
        this(classLoader, DEFAULT_SCAN_SPEC, DEFAULT_PATTERN, IPathFilter.ANY_FILTER);
    }

    public XFSInstrumentStore(ClassLoader classLoader, String rootPath, String filenamePattern, IPathFilter filter) {
        super(filter);
        this.classLoader = classLoader;
        this.setRootPath(rootPath);
        this.setPattern(filenamePattern);
    }

    @Override
    public void flush(StandardInstrument instrument) throws IOException {
        throw new IOException("can't write to classpath");
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    @Override
    public void load(StandardInstrumentRegistry registry) throws InstrumentRegistryException {
        ITrace trace = MONITOR.attach();
        try {
            Log.trace("XFSInstrumentStore enumerate {}, {}", (Object)this.getRootPath(), (Object)this.getPattern());
            XFSScanner scanner = new XFSScanner();
            scanner.setClassLoader(this.getClassLoader());
            scanner.setPattern(this.getPattern());
            scanner.setRootPath(this.getRootPath());
            scanner.scan(node -> this.onFound(registry, node));
            trace.stop();
        }
        catch (Exception ex) {
            throw (InstrumentRegistryException)ExceptionTools.createTypedFromChain((Throwable)ex, InstrumentRegistryException.class);
        }
    }

    protected void load(StandardInstrumentRegistry registry, String path, InputStream is) throws InstrumentRegistryException {
        Log.trace("XFSInstrumentStore load {}", (Object)path);
        try {
            StandardInstrument instrument = new StandardInstrument(registry, this);
            File base = new File(path).getParentFile();
            if (base != null) {
                base = base.getParentFile();
            }
            ClassLoaderResourceLocatorFactory locatorFactory = new ClassLoaderResourceLocatorFactory(this.getClassLoader());
            locatorFactory = new RelativeLocatorFactory((ILocatorFactory)locatorFactory, base == null ? "" : base.getPath());
            instrument.setLocatorFactory((ILocatorFactory)locatorFactory);
            instrument.setBaseDir(base);
            IDocument doc = ElementFactory.get().parse(is);
            if (doc instanceof IStringEvaluatorAccess) {
                ScopedResolver resolver = ScopedResolver.create((IStringEvaluator[])new IStringEvaluator[]{instrument.getExpressionEvaluator(), ExpressionEvaluator.get((Mode)Mode.TRUSTED)});
                ((IStringEvaluatorAccess)doc).setStringEvaluator((IStringEvaluator)resolver);
            }
            instrument.configure(doc.getRootElement());
            String id = instrument.getId();
            IInstrument tempInstrument = registry.lookupInstrument(id);
            if (tempInstrument == null) {
                registry.registerInstrument(instrument);
                Log.debug("instrument '{}' at '{}' defined", (Object)id, (Object)path);
            } else {
                Log.warn("instrument '{}' at '{}' redefines {}", new Object[]{id, path, tempInstrument});
            }
        }
        catch (Exception ex) {
            throw new InstrumentRegistryException("error loading instrument at '" + path + "'", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object onFound(StandardInstrumentRegistry registry, IXFSNode node) throws IOException {
        Log.trace("XFSInstrumentStore node {} found", (Object)node);
        String path = node.getPath() + node.getName();
        if (this.getFilter() != null) {
            if (!this.getFilter().accept(path)) return null;
        }
        try (InputStream is = this.getClassLoader().getResourceAsStream(path);){
            if (is == null) {
                Log.warn("XFSInstrumentStore  node {} not available", (Object)node);
                Object var5_6 = null;
                return var5_6;
            }
            this.load(registry, path, is);
            return null;
        }
        catch (InstrumentRegistryException e) {
            throw new IOException(e);
        }
    }

    public void setPattern(String locationPattern) {
        this.pattern = locationPattern;
    }

    public void setRootPath(String scanSpec) {
        this.rootPath = scanSpec;
    }
}

