/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.requestmeta.servlet;

import de.intarsys.tools.requestmeta.model.RequestMetaData;
import de.intarsys.tools.requestmeta.model.RequestMetaDataStore;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMetaFilter
implements Filter {
    private static final Logger Log = LoggerFactory.getLogger(RequestMetaFilter.class);

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Log.debug(">>> RequestMetaFilter {} {}", (Object)httpRequest.getMethod(), (Object)httpRequest.getRequestURI());
        RequestMetaData metaData = new RequestMetaData();
        try {
            httpResponse.setHeader("x-intarsys-meta-id", "" + metaData.getId());
            chain.doFilter(request, (ServletResponse)httpResponse);
        }
        finally {
            metaData.stop();
            RequestMetaDataStore.getActive().add(metaData);
        }
        Log.debug("<<< RequestMetaFilter");
        Log.debug("+- elapsed time {}", (Object)metaData.getElapsedTime());
        Log.debug("+- cpu time {}", (Object)metaData.getCpuTime());
        Log.debug("+- heap used {}", (Object)metaData.getHeapMemoryUsage().getUsed());
        Log.debug("+- non heap used {}", (Object)metaData.getNonHeapMemoryUsage().getUsed());
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }
}

