/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.correlation;

import de.intarsys.tools.correlation.CorrelationProvider;
import de.intarsys.tools.correlation.ICorrelationChangeListener;
import de.intarsys.tools.correlation.LogCorrrelationChangeListener;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;

public class CorrelationFilter
implements Filter {
    public static final String DEFAULT_CORR_PARAM_NAME = "corr";
    public static final String SOURCE_COOKIE = "cookie";
    public static final String SOURCE_PARAMETER = "parameter";
    public static final String SOURCE_HEADER = "header";
    private String source = "parameter";
    private String sourceKey = "corr";
    private String corrKey = "corr";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String value = null;
        if (SOURCE_HEADER.equals(this.getSource())) {
            value = httpRequest.getHeader(this.getSourceKey());
        } else if (SOURCE_COOKIE.equals(this.getSource())) {
            Cookie[] cookies = httpRequest.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!this.getSourceKey().equals(cookie.getName())) continue;
                    value = cookie.getValue();
                }
            }
        } else {
            value = httpRequest.getParameter(this.getSourceKey());
        }
        CorrelationProvider.get().endCorrelation();
        CorrelationProvider.get().addCorrelationId(value);
        try {
            chain.doFilter(request, (ServletResponse)httpResponse);
        }
        finally {
            CorrelationProvider.get().endCorrelation();
        }
    }

    public String getCorrKey() {
        return this.corrKey;
    }

    public String getSource() {
        return this.source;
    }

    public String getSourceKey() {
        return this.sourceKey;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        CorrelationProvider.get().addChangeListener((ICorrelationChangeListener)new LogCorrrelationChangeListener(this.getCorrKey()));
    }

    public void setCorrKey(String corrKey) {
        this.corrKey = corrKey;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setSourceKey(String sourceKey) {
        this.sourceKey = sourceKey;
    }
}

