/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.ssl;

import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IArgsAccess;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.ssl.ConfigurableKeyManagerProvider;
import de.intarsys.tools.ssl.ConfigurableTrustManagerProvider;
import de.intarsys.tools.ssl.IConfigurableSslContextProvider;
import de.intarsys.tools.ssl.IKeyManagerProvider;
import de.intarsys.tools.ssl.ISslContextProvider;
import de.intarsys.tools.ssl.ITrustManagerProvider;
import de.intarsys.tools.ssl.KeyManagerProvider;
import de.intarsys.tools.ssl.SslContextProvider;
import de.intarsys.tools.ssl.TrustManagerProvider;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableSslContextProvider
implements IConfigurableSslContextProvider,
IArgsAccess {
    private static final Logger Log = LoggerFactory.getLogger(ConfigurableSslContextProvider.class);
    public static final String PROTOCOL_TLS = "TLS";
    private static final String ARG_PROTOCOL = "protocol";
    private static final String ARG_TRUST_ALL = "trustAll";
    private static final String ARG_SSL_SESSION_TIMEOUT = "sslSessionTimeout";
    private static final int SSL_SESSION_TIMEOUT_DEFAULT = 86400;
    private String protocol;
    private String provider;
    private IKeyManagerProvider keyManagerProvider;
    private ITrustManagerProvider trustManagerProvider;
    private ConfigurableSslContextProvider baseSslContextProvider;
    private int sslSessionTimeout = 86400;
    private boolean inheritGlobal = true;

    public ConfigurableSslContextProvider() {
    }

    public ConfigurableSslContextProvider(ConfigurableSslContextProvider other) {
        this.baseSslContextProvider = other;
    }

    @Override
    public HostnameVerifier createHostnameVerifier() {
        return null;
    }

    @Override
    public IConfigurableSslContextProvider createProvider() {
        return new ConfigurableSslContextProvider(this);
    }

    @Override
    public SSLContext createSslContext() throws GeneralSecurityException, IOException {
        ITrustManagerProvider tmpTrustManagerProvider;
        KeyManager[] keyManagers = null;
        TrustManager[] trustManagers = null;
        IKeyManagerProvider tmpKeyManagerProvider = this.getResolvedKeyManagerProvider();
        if (tmpKeyManagerProvider != null) {
            keyManagers = tmpKeyManagerProvider.createKeyManagers();
        }
        if ((tmpTrustManagerProvider = this.getResolvedTrustManagerProvider()) != null) {
            trustManagers = tmpTrustManagerProvider.createTrustManagers();
        }
        SecureRandom secureRandom = null;
        SSLContext sslContext = this.getResolvedProvider() != null ? SSLContext.getInstance(this.getResolvedProtocol(), this.getResolvedProvider()) : SSLContext.getInstance(this.getResolvedProtocol());
        sslContext.getClientSessionContext().setSessionTimeout(this.getSslSessionTimeout());
        sslContext.init(keyManagers, trustManagers, secureRandom);
        Log.debug("{} SSLContext protocol {}", (Object)this, (Object)sslContext.getProtocol());
        Log.debug("{} SSLContext provider {}", (Object)this, (Object)sslContext.getProvider().getName());
        SSLParameters params = sslContext.getSupportedSSLParameters();
        Log.debug("{} SSLContext supported protocols {}", (Object)this, (Object)StringTools.join((String[])params.getProtocols(), (String)", "));
        Log.debug("{} SSLContext supported cipher suites {}", (Object)this, (Object)StringTools.join((String[])params.getCipherSuites(), (String)", "));
        params = sslContext.getDefaultSSLParameters();
        Log.debug("{} SSLContext default protocols {}", (Object)this, (Object)StringTools.join((String[])params.getProtocols(), (String)", "));
        Log.debug("{} SSLContext default cipher suites {}", (Object)this, (Object)StringTools.join((String[])params.getCipherSuites(), (String)", "));
        return sslContext;
    }

    protected void ensureKeyManagerProvider() {
        if (!(this.keyManagerProvider instanceof ConfigurableKeyManagerProvider)) {
            this.keyManagerProvider = new ConfigurableKeyManagerProvider();
        }
    }

    protected void ensureTrustManagerProvider() {
        if (!(this.trustManagerProvider instanceof ConfigurableTrustManagerProvider)) {
            this.trustManagerProvider = new ConfigurableTrustManagerProvider();
        }
    }

    public IArgs getArgs() {
        return null;
    }

    public ConfigurableSslContextProvider getBaseSslContextProvider() {
        return this.baseSslContextProvider;
    }

    public IKeyManagerProvider getKeyManagerProvider() {
        return this.keyManagerProvider;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getProvider() {
        return this.provider;
    }

    protected IKeyManagerProvider getResolvedKeyManagerProvider() {
        IKeyManagerProvider tmpKeyManagerProvider = this.getKeyManagerProvider();
        if (tmpKeyManagerProvider == null && this.getBaseSslContextProvider() != null) {
            tmpKeyManagerProvider = this.getBaseSslContextProvider().getKeyManagerProvider();
        }
        if (tmpKeyManagerProvider == null && this.isInheritGlobal()) {
            tmpKeyManagerProvider = KeyManagerProvider.get();
        }
        return tmpKeyManagerProvider;
    }

    protected String getResolvedProtocol() {
        String tmpProtocol = this.getProtocol();
        if (StringTools.isEmpty((String)tmpProtocol) && this.getBaseSslContextProvider() != null) {
            tmpProtocol = this.getBaseSslContextProvider().getProtocol();
        }
        return StringTools.isEmpty((String)tmpProtocol) ? PROTOCOL_TLS : tmpProtocol;
    }

    protected String getResolvedProvider() {
        String tmpProvider = this.getProvider();
        if (tmpProvider == null && this.getBaseSslContextProvider() != null) {
            tmpProvider = this.getBaseSslContextProvider().getProvider();
        }
        if (tmpProvider == null && this.isInheritGlobal()) {
            try {
                ISslContextProvider globalProvider = SslContextProvider.get();
                if (this == globalProvider) {
                    return null;
                }
                SSLContext tmpContext = globalProvider.createSslContext();
                tmpProvider = tmpContext.getProvider().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return tmpProvider;
    }

    protected ITrustManagerProvider getResolvedTrustManagerProvider() {
        ITrustManagerProvider tmpTrustManagerProvider = this.getTrustManagerProvider();
        if (tmpTrustManagerProvider == null && this.getBaseSslContextProvider() != null) {
            tmpTrustManagerProvider = this.getBaseSslContextProvider().getTrustManagerProvider();
        }
        if (tmpTrustManagerProvider == null && this.isInheritGlobal()) {
            tmpTrustManagerProvider = TrustManagerProvider.get();
        }
        return tmpTrustManagerProvider;
    }

    public int getSslSessionTimeout() {
        return this.sslSessionTimeout;
    }

    public ITrustManagerProvider getTrustManagerProvider() {
        return this.trustManagerProvider;
    }

    public boolean isInheritGlobal() {
        return this.inheritGlobal;
    }

    public void setArgs(IArgs args) {
        String argProtocol = ArgTools.getString((IArgs)args, (String)ARG_PROTOCOL, null);
        boolean argTrustAll = ArgTools.getBoolean((IArgs)args, (String)ARG_TRUST_ALL, (boolean)false);
        int argSslSessionTimeout = ArgTools.getInt((IArgs)args, (String)ARG_SSL_SESSION_TIMEOUT, (int)86400);
        this.setProtocol(argProtocol);
        this.setTrustAll(argTrustAll);
        this.setSslSessionTimeout(argSslSessionTimeout);
        this.ensureKeyManagerProvider();
        IKeyManagerProvider iKeyManagerProvider = this.getKeyManagerProvider();
        if (iKeyManagerProvider instanceof ConfigurableKeyManagerProvider) {
            ConfigurableKeyManagerProvider ckmp = (ConfigurableKeyManagerProvider)iKeyManagerProvider;
            ckmp.setArgs(args);
        }
    }

    public void setBaseSslContextProvider(ConfigurableSslContextProvider baseSslContextProvider) {
        this.baseSslContextProvider = baseSslContextProvider;
    }

    public void setInheritGlobal(boolean inheritGlobal) {
        this.inheritGlobal = inheritGlobal;
    }

    @Override
    public void setKeyManagerProvider(IKeyManagerProvider keyManagerProvider) {
        this.keyManagerProvider = keyManagerProvider;
    }

    public void setKeyPassword(Secret keyPassword) {
        this.ensureKeyManagerProvider();
        ((ConfigurableKeyManagerProvider)this.keyManagerProvider).setKeyPassword(keyPassword);
    }

    public void setKeyStore(KeyStore keyStore) {
        this.ensureKeyManagerProvider();
        ((ConfigurableKeyManagerProvider)this.keyManagerProvider).setKeyStore(keyStore);
    }

    public void setKeyStoreName(String keyStoreName) {
        this.ensureKeyManagerProvider();
        try {
            ((ConfigurableKeyManagerProvider)this.keyManagerProvider).setKeyStoreLocator(LocatorTools.createLocator((Object)keyStoreName, null, null));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setKeyStorePassword(Secret keyStorePassword) {
        this.ensureKeyManagerProvider();
        ((ConfigurableKeyManagerProvider)this.keyManagerProvider).setKeyStorePassword(keyStorePassword);
    }

    public void setKeyStoreType(String keyStoreType) {
        this.ensureKeyManagerProvider();
        ((ConfigurableKeyManagerProvider)this.keyManagerProvider).setKeyStoreType(keyStoreType);
    }

    @Override
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @Override
    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setSslSessionTimeout(int sslSessionTimeout) {
        this.sslSessionTimeout = sslSessionTimeout;
    }

    public void setTrustAll(boolean trustAll) {
        this.ensureTrustManagerProvider();
        ((ConfigurableTrustManagerProvider)this.trustManagerProvider).setTrustAll(trustAll);
    }

    @Override
    public void setTrustManagerProvider(ITrustManagerProvider trustManagerProvider) {
        this.trustManagerProvider = trustManagerProvider;
    }

    public void setTrustStore(KeyStore trustStore) {
        this.ensureTrustManagerProvider();
        ((ConfigurableTrustManagerProvider)this.trustManagerProvider).setTrustStore(trustStore);
    }

    public void setTrustStoreName(String trustStoreName) {
        this.ensureTrustManagerProvider();
        try {
            ((ConfigurableTrustManagerProvider)this.trustManagerProvider).setTrustStoreLocator(LocatorTools.createLocator((Object)trustStoreName, null, null));
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setTrustStorePassword(Secret trustStorePassword) {
        this.ensureTrustManagerProvider();
        ((ConfigurableTrustManagerProvider)this.trustManagerProvider).setTrustStorePassword(trustStorePassword);
    }
}

