/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.PatternFormat;

public class TimeFormat
extends PatternFormat {
    public static final String TYPE = "time";
    public static String[] PATTERNS = new String[]{"HH:MM", "h:MM tt", "HH:MM:ss", "h:MM:ss tt"};

    public TimeFormat() {
    }

    public TimeFormat(int index) {
        super(index);
    }

    public TimeFormat(String pattern) {
        super(pattern);
    }

    @Override
    protected void generateScripts() {
        int index = this.getPatternIndex();
        if (index > -1) {
            this.generateScriptsIndex(index);
        } else {
            this.generateScriptsPattern(this.getPattern());
        }
    }

    protected void generateScriptsIndex(int index) {
        this.setFormatScript(this.createScript("AFTime_Format", index));
        this.setKeyStrokeScript(this.createScript("AFTime_Keystroke", PATTERNS[index]));
    }

    protected void generateScriptsPattern(String pattern) {
        this.setFormatScript(this.createScript("AFTime_FormatEx", pattern));
        this.setKeyStrokeScript(this.createScript("AFTime_Keystroke", pattern));
    }

    @Override
    public String[] getBuiltInPatterns() {
        return PATTERNS;
    }

    @Override
    protected String getDefaultPattern() {
        return PATTERNS[0];
    }

    @Override
    protected String getPatternLabel(int index) {
        return PATTERNS[index];
    }

    @Override
    public String getType() {
        return TYPE;
    }
}

