/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.widget.format;

import de.intarsys.pdf.design.widget.format.DateFormat;
import de.intarsys.pdf.design.widget.format.FieldCalculationRule;
import de.intarsys.pdf.design.widget.format.PACKAGE;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;

public class DateCalculationRule
extends FieldCalculationRule {
    public static final String TYPE = "date";
    public static final String DATE_NOW = "NOW";
    public static final String[] DATETYPES = new String[]{"NOW"};
    public static final String[] PATTERNS;
    private static final IMessageBundle Msg;
    private String dateType = "NOW";
    private String pattern = PATTERNS[0];

    @Override
    protected void generateScripts() {
        StringBuilder script = new StringBuilder();
        script.append(this.loadFunctionScript()).append(StringTools.LS);
        script.append("EXTDate(");
        if (this.getDateType() == null) {
            script.append("null");
        } else {
            script.append("'").append(this.getDateType()).append("'");
        }
        script.append(",");
        if (this.getPattern() == null) {
            script.append("null");
        } else {
            script.append("'").append(this.getPattern()).append("'");
        }
        script.append(");");
        this.setCalculationScript(script.toString());
    }

    public String getDateType() {
        return this.dateType;
    }

    public String getDateTypeLabel(String dateType) {
        return Msg.getString("DateCalculationRule.DateTypeLabel." + dateType, new Object[0]);
    }

    public String getPattern() {
        return this.pattern;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    protected String loadFunctionScript() {
        InputStream is = this.getClass().getResourceAsStream("EXTDate.js");
        try {
            return StreamTools.getString((InputStream)is, (Charset)null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public void setDateType(String operation) {
        this.dateType = operation;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    static {
        Msg = PACKAGE.Messages;
        List datePatterns = new DateFormat().getDisplayPatterns();
        PATTERNS = datePatterns.toArray(new String[datePatterns.size()]);
    }
}

