/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design.markup;

import de.intarsys.pdf.app.design.AnnotationDesignerException;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.design.AbstractAnnotationDesigner;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPopupAnnotation;
import de.intarsys.pdf.tools.kernel.PDFColorTools;
import de.intarsys.pdf.tools.kernel.PDFGeometryTools;
import de.intarsys.tools.geometry.GeometryTools;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public abstract class MarkupDesigner
extends AbstractAnnotationDesigner {
    protected MarkupDesigner() {
    }

    @Override
    public PDAnnotation addTransferable(PDAnnotation annotation, PDPage page) throws AnnotationDesignerException {
        PDMarkupAnnotation copy = (PDMarkupAnnotation)super.addTransferable(annotation, page);
        PDPopupAnnotation copyPopup = (PDPopupAnnotation)copy.getPopup();
        if (copyPopup != null) {
            Rectangle2D copyPopupRect = copyPopup.getRectangle().toNormalizedRectangle();
            AffineTransform transform = new AffineTransform();
            Rectangle2D pagerect = page.getCropBox().toNormalizedRectangle();
            PDFGeometryTools.applyUSRtoDS((AffineTransform)transform, (PDPage)page, (Rectangle2D)pagerect, (double)1.0);
            GeometryTools.inverseTransformRect((AffineTransform)transform, (Rectangle2D)copyPopupRect);
            copyPopup.setRectangle(new CDSRectangle(copyPopupRect));
            copyPopup.setParent((PDAnnotation)copy);
            page.addAnnotation((PDAnnotation)copyPopup);
        }
        return copy;
    }

    @Override
    protected void basicSetBorderColor(PDAnnotation annotation, float[] color) {
        ((PDMarkupAnnotation)annotation).setColor(color);
    }

    @Override
    public PDAnnotation createTransferable(PDAnnotation annotation) {
        PDMarkupAnnotation copy = (PDMarkupAnnotation)super.createTransferable(annotation);
        PDPage page = PDAnnotationTools.getPage((PDAnnotation)annotation);
        PDAnnotation copyPopup = copy.getPopup();
        if (copyPopup != null) {
            copyPopup.cosRemoveField(PDAnnotation.DK_P);
            copyPopup.cosRemoveField(PDPopupAnnotation.DK_Parent);
            Rectangle2D copyPopupRect = copyPopup.getRectangle().toNormalizedRectangle();
            AffineTransform transform = new AffineTransform();
            Rectangle2D pagerect = page.getCropBox().toNormalizedRectangle();
            PDFGeometryTools.applyUSRtoDS((AffineTransform)transform, (PDPage)page, (Rectangle2D)pagerect, (double)1.0);
            GeometryTools.transformRect((AffineTransform)transform, (Rectangle2D)copyPopupRect);
            copyPopup.setRectangle(new CDSRectangle(copyPopupRect));
        }
        return copy;
    }

    @Override
    public void deleteAnnotation(PDAnnotation annotation) {
        super.deleteAnnotation(annotation);
        PDAnnotation popup = ((PDMarkupAnnotation)annotation).getPopup();
        if (popup != null) {
            popup.dispose();
        }
    }

    @Override
    public float[] getBorderColor(PDAnnotation annotation) {
        return PDFColorTools.fixColorValues((float[])((PDMarkupAnnotation)annotation).getColor());
    }

    @Override
    public boolean supports(PDDocument doc) {
        return doc.getAccessPermissions().mayModifyAnnotation();
    }

    @Override
    public boolean supportsBorderColor() {
        return true;
    }
}

