/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.design;

import de.intarsys.pdf.app.annotation.IAnnotationReference;
import de.intarsys.pdf.app.annotation.widget.WidgetFactory;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.tools.enumeration.common.EnumDistanceUnit;
import de.intarsys.tools.enumeration.common.EnumUnit;
import de.intarsys.tools.lang.LangTools;
import de.intarsys.tools.presentation.IPresentationSupport;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public abstract class CommonAnnotationReference
implements IAnnotationReference,
IPresentationSupport {
    private boolean visible = true;
    private Point2D positionScaled;
    private Point2D sizeScaled;
    private String subType;
    private Map attributes;
    private String uniqueName;
    private PDAnnotation annotation;
    private EnumDistanceUnit distanceUnit = EnumDistanceUnit.POINT;
    private PDDocument document;

    protected CommonAnnotationReference(CommonAnnotationReference ref, PDDocument doc) {
        this.annotation = null;
        if (ref.attributes != null) {
            this.attributes = new HashMap(ref.attributes);
        }
        this.distanceUnit = ref.distanceUnit;
        this.document = doc;
        this.positionScaled = ref.positionScaled;
        this.sizeScaled = ref.sizeScaled;
        this.subType = ref.subType;
        this.uniqueName = ref.uniqueName;
        this.visible = ref.visible;
    }

    protected CommonAnnotationReference(PDAnnotation annotation) {
        this.annotation = annotation;
        if (annotation != null) {
            this.document = annotation.getDoc();
        }
    }

    protected CommonAnnotationReference(PDDocument doc) {
        this.document = doc;
    }

    protected final PDAnnotation basicGetAnnotation() {
        return this.annotation;
    }

    protected PDAnnotation createAnnotation() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof CommonAnnotationReference) {
            return LangTools.equals((Object)this.getUniqueName(), (Object)((CommonAnnotationReference)obj).getUniqueName());
        }
        return false;
    }

    public PDAnnotation getAnnotation() {
        if (this.annotation == null) {
            this.annotation = this.createAnnotation();
        }
        return this.annotation;
    }

    public Map getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        return this.attributes;
    }

    public String getDescription() {
        return this.getTip();
    }

    public EnumDistanceUnit getDistanceUnit() {
        return this.distanceUnit;
    }

    public PDDocument getDocument() {
        return this.document;
    }

    public String getFieldName() {
        return WidgetFactory.getFieldName(this.getAttributes());
    }

    public String getIconName() {
        return null;
    }

    public String getLabel() {
        return null;
    }

    public Point2D getPosition() {
        if (this.positionScaled != null) {
            if (EnumDistanceUnit.POINT == this.getDistanceUnit()) {
                return this.positionScaled;
            }
            return new Point2D.Double(this.getDistanceUnit().convertTo((EnumUnit)EnumDistanceUnit.POINT, this.positionScaled.getX()), this.getDistanceUnit().convertTo((EnumUnit)EnumDistanceUnit.POINT, this.positionScaled.getY()));
        }
        if (this.basicGetAnnotation() != null) {
            CDSRectangle rect = this.basicGetAnnotation().getNormalizedRectangle();
            return new Point2D.Float(rect.getLowerLeftX(), rect.getLowerLeftY());
        }
        return null;
    }

    public Point2D getPositionScaled() {
        return this.positionScaled;
    }

    public Point2D getSize() {
        if (this.sizeScaled != null) {
            if (EnumDistanceUnit.POINT == this.getDistanceUnit()) {
                return this.sizeScaled;
            }
            return new Point2D.Double(this.getDistanceUnit().convertTo((EnumUnit)EnumDistanceUnit.POINT, this.sizeScaled.getX()), this.getDistanceUnit().convertTo((EnumUnit)EnumDistanceUnit.POINT, this.sizeScaled.getY()));
        }
        if (this.basicGetAnnotation() != null) {
            CDSRectangle rect = this.basicGetAnnotation().getNormalizedRectangle();
            return new Point2D.Float(rect.getWidth(), rect.getHeight());
        }
        return null;
    }

    public Point2D getSizeScaled() {
        return this.sizeScaled;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getTip() {
        return this.getLabel();
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public int hashCode() {
        if (this.getUniqueName() == null) {
            return super.hashCode();
        }
        return this.getUniqueName().hashCode();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void refresh() {
    }

    protected void setAnnotation(PDAnnotation annotation) {
        this.annotation = annotation;
    }

    public void setAttributes(Map attributes) {
        this.attributes = attributes;
    }

    public void setDistanceUnit(EnumDistanceUnit distanceUnit) {
        this.distanceUnit = distanceUnit;
    }

    public void setPositionScaled(Point2D position) {
        this.positionScaled = position;
    }

    public void setSizeScaled(Point2D size) {
        this.sizeScaled = size;
    }

    public void setSubType(String type) {
        this.subType = type;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public void setVisible(boolean visisble) {
        this.visible = visisble;
    }
}

