/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.cli;

import de.intarsys.tools.cli.ICLIOptionDescriptor;
import de.intarsys.tools.cli.ICLIOptionProcessor;

public class CLIOptionDescriptor
implements ICLIOptionDescriptor {
    private String opt;
    private String longOpt;
    private boolean mainOption;
    private String description;

    public CLIOptionDescriptor(String opt, String longOpt, String description) throws IllegalArgumentException {
        this.validateOption(opt);
        this.opt = opt;
        this.longOpt = longOpt;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public String getLongOpt() {
        return this.longOpt;
    }

    @Override
    public String getOpt() {
        return this.opt;
    }

    @Override
    public ICLIOptionProcessor getOptionProcessor() {
        return null;
    }

    public boolean hasLongOpt() {
        return this.longOpt != null;
    }

    @Override
    public boolean isMainOption() {
        return this.mainOption;
    }

    private boolean isValidChar(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private boolean isValidOpt(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == ' ' || c == '?' || c == '@';
    }

    public void setLongOpt(String longOpt) {
        this.longOpt = longOpt;
    }

    public void setMainOption(boolean mainOption) {
        this.mainOption = mainOption;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append("[ option: ");
        buf.append(this.opt);
        if (this.longOpt != null) {
            buf.append(" ").append(this.longOpt);
        }
        buf.append(" ");
        buf.append(" :: ").append(this.description);
        buf.append(" ]");
        return buf.toString();
    }

    private void validateOption(String opt) throws IllegalArgumentException {
        if (opt == null) {
            throw new IllegalArgumentException("opt is null");
        }
        if (opt.length() == 1) {
            char ch = opt.charAt(0);
            if (!this.isValidOpt(ch)) {
                throw new IllegalArgumentException("illegal option value '" + ch + "'");
            }
        } else {
            int len = opt.length();
            for (int i = 0; i < len; ++i) {
                if (this.isValidChar(opt.charAt(i))) continue;
                throw new IllegalArgumentException("opt contains illegal character value '" + opt.charAt(i) + "'");
            }
        }
    }
}

