/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.undo;

import de.intarsys.document.undo.IUndoAction;
import de.intarsys.document.undo.PACKAGE;
import de.intarsys.document.undo.UndoEvent;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.message.IMessageBundle;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndoManager
implements INotificationSupport {
    private static final Attribute ATTR_UNDO_MANAGER = new Attribute("undoManager");
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(UndoManager.class);
    private int maxUndos = 100;
    private final LinkedList redoActions = new LinkedList();
    private final LinkedList undoActions = new LinkedList();
    private final IAttributeSupport context;
    private EventDispatcher dispatcher = new EventDispatcher((Object)this);

    public static UndoManager get(IAttributeSupport context) {
        if (context == null) {
            return null;
        }
        UndoManager result = (UndoManager)context.getAttribute((Object)ATTR_UNDO_MANAGER);
        if (result == null) {
            result = new UndoManager(context);
        }
        return result;
    }

    public static String getLabelRedoDefault() {
        return Msg.getString("UndoManager.redoDefault", new Object[0]);
    }

    public static String getLabelUndoDefault() {
        return Msg.getString("UndoManager.undoDefault", new Object[0]);
    }

    protected UndoManager(IAttributeSupport context) {
        context.setAttribute((Object)ATTR_UNDO_MANAGER, (Object)this);
        this.context = context;
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    public void clear() {
        this.undoActions.clear();
        this.redoActions.clear();
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, (Object)"actions", null, null);
        this.triggerEvent((Event)event);
    }

    public void clearRedo() {
        this.redoActions.clear();
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, (Object)"actions", null, null);
        this.triggerEvent((Event)event);
    }

    public IAttributeSupport getContext() {
        return this.context;
    }

    public String getLabelRedo() {
        if (this.redoActions.isEmpty()) {
            return UndoManager.getLabelRedoDefault();
        }
        IUndoAction redoAction = (IUndoAction)this.redoActions.getLast();
        return Msg.getString("UndoManager.redo", new Object[]{redoAction.getLabel()});
    }

    public String getLabelUndo() {
        if (this.undoActions.isEmpty()) {
            return UndoManager.getLabelUndoDefault();
        }
        IUndoAction undoAction = (IUndoAction)this.undoActions.getLast();
        return Msg.getString("UndoManager.undo", new Object[]{undoAction.getLabel()});
    }

    public int getMaxUndos() {
        return this.maxUndos;
    }

    public boolean hasRedos() {
        return !this.redoActions.isEmpty();
    }

    public boolean hasUndos() {
        return !this.undoActions.isEmpty();
    }

    public IUndoAction peekRedo() {
        if (this.redoActions.isEmpty()) {
            return null;
        }
        return (IUndoAction)this.redoActions.getLast();
    }

    public IUndoAction peekUndo() {
        if (this.undoActions.isEmpty()) {
            return null;
        }
        return (IUndoAction)this.undoActions.getLast();
    }

    public IUndoAction popUndo() {
        if (this.undoActions.isEmpty()) {
            return null;
        }
        IUndoAction pop = (IUndoAction)this.undoActions.removeLast();
        this.redoActions.clear();
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, (Object)"actions", null, null);
        this.triggerEvent((Event)event);
        return pop;
    }

    public void pushUndo(IUndoAction undoAction) {
        this.undoActions.add(undoAction);
        if (this.undoActions.size() > this.getMaxUndos()) {
            this.undoActions.remove(0);
        }
        this.redoActions.clear();
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, (Object)"actions", null, null);
        this.triggerEvent((Event)event);
    }

    public IUndoAction redo() {
        if (this.redoActions.isEmpty()) {
            return null;
        }
        IUndoAction redoAction = (IUndoAction)this.redoActions.removeLast();
        this.undoActions.add(redoAction);
        redoAction.redo();
        UndoEvent event = new UndoEvent(this);
        this.triggerEvent(event);
        return redoAction;
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    public void setMaxUndos(int maxUndos) {
        this.maxUndos = maxUndos;
    }

    protected void triggerEvent(Event event) {
        try {
            this.dispatcher.triggerEvent(event);
        }
        catch (RuntimeException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public IUndoAction undo() {
        if (this.undoActions.isEmpty()) {
            return null;
        }
        IUndoAction undoAction = (IUndoAction)this.undoActions.removeLast();
        this.redoActions.add(undoAction);
        undoAction.undo();
        UndoEvent event = new UndoEvent(this);
        this.triggerEvent(event);
        return undoAction;
    }
}

