/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.document.location;

import de.intarsys.document.location.ILocation;
import de.intarsys.document.location.ILocationSupport;
import de.intarsys.document.location.Location;
import de.intarsys.document.location.LocationEvent;
import de.intarsys.document.location.PACKAGE;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.message.IMessageBundle;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocationManager
implements INotificationSupport {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private static final Logger Log = LoggerFactory.getLogger(LocationManager.class);
    private static final Attribute ATTR_LOCATION_MANAGER = new Attribute("navigationManager");
    private EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private final LinkedList backwardLocations = new LinkedList();
    private ILocationSupport context;
    private final LinkedList forwardLocations = new LinkedList();
    private int maxLocations = 100;
    private boolean navigationActive = false;

    public static LocationManager get(IAttributeSupport context) {
        if (context == null) {
            return null;
        }
        LocationManager result = (LocationManager)context.getAttribute((Object)ATTR_LOCATION_MANAGER);
        if (result == null && context instanceof ILocationSupport) {
            result = new LocationManager((ILocationSupport)context);
            context.setAttribute((Object)ATTR_LOCATION_MANAGER, (Object)result);
        }
        return result;
    }

    public static String getLabelBackwardDefault() {
        return Msg.getString("LocationManager.TooltipBackwardDefault", new Object[0]);
    }

    public static String getLabelForwardDefault() {
        return Msg.getString("LocationManager.TooltipForwardDefault", new Object[0]);
    }

    public static void recordLocation(IAttributeSupport context) {
        LocationManager locationManager = LocationManager.get(context);
        if (locationManager != null) {
            locationManager.recordLocation();
        }
    }

    protected LocationManager(ILocationSupport context) {
        this.context = context;
    }

    public void addLocation(ILocation location) {
        if (this.navigationActive) {
            return;
        }
        this.backwardLocations.add(location);
        if (this.backwardLocations.size() > this.getMaxLocations()) {
            this.backwardLocations.remove(0);
        }
        this.forwardLocations.clear();
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, (Object)"locations", null, null);
        this.triggerEvent((Event)event);
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backward() {
        if (this.backwardLocations.isEmpty()) {
            return;
        }
        try {
            this.navigationActive = true;
            Location location = (Location)this.backwardLocations.removeLast();
            ILocation currentLocation = this.getContext().createLocation();
            if (currentLocation != null) {
                this.forwardLocations.add(currentLocation);
            }
            location.open();
            LocationEvent event = new LocationEvent(this);
            this.triggerEvent(event);
        }
        finally {
            this.navigationActive = false;
        }
    }

    public void clear() {
        if (this.navigationActive) {
            return;
        }
        this.backwardLocations.clear();
        this.forwardLocations.clear();
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, (Object)"locations", null, null);
        this.triggerEvent((Event)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forward() {
        if (this.forwardLocations.isEmpty()) {
            return;
        }
        try {
            this.navigationActive = true;
            Location location = (Location)this.forwardLocations.removeLast();
            ILocation currentLocation = this.getContext().createLocation();
            if (currentLocation != null) {
                this.backwardLocations.add(currentLocation);
            }
            location.open();
            LocationEvent event = new LocationEvent(this);
            this.triggerEvent(event);
        }
        finally {
            this.navigationActive = false;
        }
    }

    public ILocationSupport getContext() {
        return this.context;
    }

    public String getLabelBackward() {
        if (this.backwardLocations.isEmpty()) {
            return LocationManager.getLabelBackwardDefault();
        }
        return Msg.getString("LocationManager.TooltipBackward", new Object[0]);
    }

    public String getLabelForward() {
        if (this.forwardLocations.isEmpty()) {
            return LocationManager.getLabelForwardDefault();
        }
        return Msg.getString("LocationManager.TooltipForward", new Object[0]);
    }

    public int getMaxLocations() {
        return this.maxLocations;
    }

    public boolean hasBackwards() {
        return !this.backwardLocations.isEmpty();
    }

    public boolean hasForwards() {
        return !this.forwardLocations.isEmpty();
    }

    public void recordLocation() {
        ILocation location;
        if (this.context instanceof ILocationSupport && (location = this.context.createLocation()) != null) {
            this.addLocation(location);
        }
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    public void setMaxLocations(int maxUndos) {
        this.maxLocations = maxUndos;
    }

    protected void triggerEvent(Event event) {
        try {
            this.dispatcher.triggerEvent(event);
        }
        catch (RuntimeException e) {
            Log.warn(e.getMessage(), (Throwable)e);
        }
    }
}

