/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging.logback;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.core.Appender;
import de.intarsys.tools.logging.logback.CommonAppenderFactory;
import de.intarsys.tools.logging.logback.DelegatingAppender;
import de.intarsys.tools.logging.logback.ThreadFilter;
import java.io.IOException;
import org.slf4j.LoggerFactory;

public class LogSwitcher {
    private Appender appender;
    private boolean appenderPerAttach;
    private String loggerName = "";
    private final Appender appenderAttached = new DelegatingAppender(){

        protected void append(Object eventObject) {
            if (LogSwitcher.this.getAppender() == null) {
                return;
            }
            if (LogSwitcher.this.getFilter().isLoggable(eventObject)) {
                LogSwitcher.this.getAppender().doAppend(eventObject);
            }
        }

        public Appender getBaseAppender() {
            return LogSwitcher.this.getAppender();
        }
    };
    private final Appender appenderDetached = new DelegatingAppender(){

        protected void append(Object eventObject) {
            if (LogSwitcher.this.getAppender() == null) {
                return;
            }
            if (!LogSwitcher.this.getFilter().isLoggable(eventObject)) {
                LogSwitcher.this.getAppender().doAppend(eventObject);
            }
        }

        public Appender getBaseAppender() {
            return LogSwitcher.this.getAppender();
        }
    };
    private final ThreadFilter filter = new ThreadFilter(false);
    private int attachCounter;
    private CommonAppenderFactory appenderFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach() {
        LogSwitcher logSwitcher = this;
        synchronized (logSwitcher) {
            this.getFilter().activate();
            if (this.attachCounter++ == 0) {
                if (this.isAppenderPerAttach()) {
                    this.close();
                }
                try {
                    this.open();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                Logger logger = (Logger)LoggerFactory.getLogger((String)this.getLoggerName());
                logger.addAppender(this.getAppenderAttached());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        LogSwitcher logSwitcher = this;
        synchronized (logSwitcher) {
            if (this.appender != null) {
                this.appender.stop();
                this.appender = null;
            }
        }
    }

    protected Appender createAppender() throws IOException {
        if (this.appenderFactory == null) {
            return null;
        }
        return this.appenderFactory.createAppender();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach() {
        LogSwitcher logSwitcher = this;
        synchronized (logSwitcher) {
            this.getFilter().deactivate();
            if (--this.attachCounter == 0) {
                Logger logger = (Logger)LoggerFactory.getLogger((String)this.getLoggerName());
                logger.detachAppender(this.getAppenderAttached());
            }
        }
    }

    public Appender getAppender() {
        return this.appender;
    }

    public Appender getAppenderAttached() {
        return this.appenderAttached;
    }

    public Appender getAppenderDetached() {
        return this.appenderDetached;
    }

    public CommonAppenderFactory getAppenderFactory() {
        return this.appenderFactory;
    }

    protected ThreadFilter getFilter() {
        return this.filter;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public boolean isAppenderPerAttach() {
        return this.appenderPerAttach;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() throws IOException {
        LogSwitcher logSwitcher = this;
        synchronized (logSwitcher) {
            if (this.appender != null) {
                return false;
            }
            this.appender = this.createAppender();
            return true;
        }
    }

    public void setAppenderFactory(CommonAppenderFactory appenderFactory) {
        this.appenderFactory = appenderFactory;
    }

    public void setAppenderPerAttach(boolean logPerRequest) {
        this.appenderPerAttach = logPerRequest;
    }

    public void setLoggerName(String loggerName) {
        this.loggerName = loggerName;
    }
}

