/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging.logback;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import de.intarsys.tools.environment.file.FileEnvironment;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.StringEvaluatorTools;
import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.logging.logback.CommonAppenderFactory;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.slf4j.LoggerFactory;

public class FileAppenderFactory
extends CommonAppenderFactory {
    private static final String PROP_JAVA_IO_TMPDIR = "java.io.tmpdir";
    private static final String PROP_USER_HOME = "user.home";
    private static final String PERCENT = "%";
    private static final String ZERO = "0";
    private static final String EXPAND_PERCENT = "%%";
    private static final String EXPAND_U = "%u";
    private static final String EXPAND_G = "%g";
    private static final String EXPAND_H = "%h";
    private static final String EXPAND_T = "%t";
    private static final int FILE_COUNT = 5;
    private static final int FILE_SIZE = 1000000;
    public static final String DEFAULT_ROLLING_PATTERN = "_%d{yyyy-MM-dd}.zip";
    public static final String DEFAULT_LOGFILENAME = "log.log";
    private String filename = "log.log";
    private int limit = 1000000;
    private int count = 5;
    private boolean append;
    private boolean useProfileDir = true;
    private String encoding;

    @Override
    protected Appender basicCreateAppender() throws IOException {
        Context context = (Context)LoggerFactory.getILoggerFactory();
        RollingFileAppender appender = new RollingFileAppender();
        appender.setContext(context);
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(context);
        encoder.setOutputPatternAsHeader(false);
        encoder.setPattern(this.getPattern());
        if (!StringTools.isEmpty((String)this.getEncoding())) {
            encoder.setCharset(Charset.forName(this.getEncoding()));
        }
        encoder.start();
        TimeBasedRollingPolicy policy = new TimeBasedRollingPolicy();
        policy.setContext(context);
        policy.setCleanHistoryOnStart(false);
        File file = this.createFile();
        String filenamePattern = file.getAbsolutePath();
        String rollingPattern = filenamePattern + DEFAULT_ROLLING_PATTERN;
        policy.setFileNamePattern(rollingPattern);
        policy.setMaxHistory(this.getCount());
        policy.setParent((FileAppender)appender);
        policy.start();
        appender.setEncoder((Encoder)encoder);
        appender.setFile(filenamePattern);
        appender.setRollingPolicy((RollingPolicy)policy);
        return appender;
    }

    protected File createFile() throws IOException {
        String tempName = this.getFilename();
        if (StringTools.isEmpty((String)tempName)) {
            tempName = DEFAULT_LOGFILENAME;
        }
        tempName = StringEvaluatorTools.evaluateString((IStringEvaluator)this.getTemplateEvaluator(), (String)tempName);
        tempName = this.expand(tempName);
        tempName = FileTools.trimPath((String)tempName);
        File parent = this.isUseProfileDir() ? FileEnvironment.get().getProfileDir() : FileEnvironment.get().getBaseDir();
        File tempFile = FileTools.resolvePath((File)parent, (String)tempName);
        if (tempFile.getParentFile() != null) {
            FileTools.mkdirs((File)tempFile.getParentFile());
        }
        return tempFile;
    }

    protected String expand(String value) {
        String tmpDir;
        String expanded = value;
        int index = expanded.indexOf(EXPAND_T);
        if (index >= 0) {
            tmpDir = System.getProperty(PROP_JAVA_IO_TMPDIR);
            if (tmpDir == null) {
                tmpDir = System.getProperty(PROP_USER_HOME);
            }
            expanded = expanded.replace(EXPAND_T, tmpDir);
        }
        if ((index = expanded.indexOf(EXPAND_H)) >= 0) {
            tmpDir = System.getProperty(PROP_USER_HOME);
            expanded = expanded.replace(EXPAND_H, tmpDir);
        }
        if ((index = expanded.indexOf(EXPAND_G)) >= 0) {
            expanded = expanded.replace(EXPAND_G, ZERO);
        }
        if ((index = expanded.indexOf(EXPAND_U)) >= 0) {
            expanded = expanded.replace(EXPAND_U, ZERO);
        }
        if ((index = expanded.indexOf(EXPAND_PERCENT)) >= 0) {
            expanded = expanded.replace(EXPAND_PERCENT, PERCENT);
        }
        return expanded;
    }

    public int getCount() {
        return this.count;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getFilename() {
        return this.filename;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isAppend() {
        return this.append;
    }

    public boolean isUseProfileDir() {
        return this.useProfileDir;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setFilename(String filename) {
        String pFilename = filename;
        pFilename = pFilename.replace("${u}", EXPAND_U);
        pFilename = pFilename.replace("${g}", EXPAND_G);
        this.filename = pFilename = pFilename.replace("${h}", EXPAND_H);
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setUseProfileDir(boolean useProfileDir) {
        this.useProfileDir = useProfileDir;
    }
}

